/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.loot;

import java.util.Set;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.common.attachments.component.UpgradeAware;
import mekanism.common.item.loot.MekanismLootFunctions;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.tile.interfaces.IUpgradeTile;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

@MethodsReturnNonnullByDefault
@ParametersAreNotNullByDefault
public class CopyUpgradesLootFunction
implements LootItemFunction {
    public static final CopyUpgradesLootFunction INSTANCE = new CopyUpgradesLootFunction();

    private CopyUpgradesLootFunction() {
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)MekanismLootFunctions.COPY_UPGRADES.get();
    }

    public ItemStack apply(ItemStack stack, LootContext lootContext) {
        BlockEntity blockEntity = (BlockEntity)lootContext.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof IUpgradeTile) {
            IUpgradeTile tile = (IUpgradeTile)blockEntity;
            ((UpgradeAware)stack.getData(MekanismAttachmentTypes.UPGRADES)).copyFrom(tile.getComponent());
        }
        return stack;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return MekanismLootFunctions.BLOCK_ENTITY_LOOT_CONTEXT;
    }

    public static LootItemFunction.Builder builder() {
        return () -> INSTANCE;
    }
}

