/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.predicate;

import com.mojang.serialization.Codec;
import java.util.List;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.item.gear.ItemCanteen;
import mekanism.common.item.predicate.MekanismItemPredicates;
import mekanism.common.registries.MekanismFluids;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.advancements.critereon.ICustomItemPredicate;
import org.jetbrains.annotations.NotNull;

public class FullCanteenItemPredicate
implements ICustomItemPredicate {
    public static final FullCanteenItemPredicate INSTANCE = new FullCanteenItemPredicate();

    private FullCanteenItemPredicate() {
    }

    public Codec<? extends ICustomItemPredicate> codec() {
        return (Codec)MekanismItemPredicates.FULL_CANTEEN.get();
    }

    public boolean test(@NotNull ItemStack stack) {
        if (stack.getItem() instanceof ItemCanteen) {
            List<IExtendedFluidTank> tanks = ContainerType.FLUID.getAttachmentContainersIfPresent((IAttachmentHolder)stack);
            return !tanks.isEmpty() && tanks.stream().allMatch(tank -> tank.getNeeded() == 0 && tank.getFluid().is((Fluid)MekanismFluids.NUTRITIONAL_PASTE.getFluid()));
        }
        return false;
    }
}

