/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.predicate;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Set;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.common.item.predicate.MekanismItemPredicates;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.advancements.critereon.ICustomItemPredicate;
import org.jetbrains.annotations.NotNull;

public class MaxedModuleContainerItemPredicate
implements ICustomItemPredicate {
    private final Set<ModuleData<?>> supportedModules;
    private final Item item;

    public MaxedModuleContainerItemPredicate(Item item) {
        this.item = item;
        this.supportedModules = IModuleHelper.INSTANCE.getSupported(this.item);
    }

    public boolean test(@NotNull ItemStack stack) {
        IModuleContainer container;
        if (stack.is(this.item) && (container = IModuleHelper.INSTANCE.getModuleContainerNullable(stack)) != null && container.moduleTypes().containsAll(this.supportedModules)) {
            for (IModule<?> module : container.modules()) {
                if (module.getInstalledCount() == module.getData().getMaxStackSize()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Codec<? extends ICustomItemPredicate> codec() {
        return (Codec)MekanismItemPredicates.MAXED_MODULE_CONTAINER_ITEM.get();
    }

    static Codec<MaxedModuleContainerItemPredicate> makeCodec() {
        return BuiltInRegistries.ITEM.byNameCodec().comapFlatMap(item -> {
            if (IModuleHelper.INSTANCE.isModuleContainer((Item)item)) {
                return DataResult.success((Object)new MaxedModuleContainerItemPredicate((Item)item));
            }
            return DataResult.error(() -> "Specified item is not a module container item.");
        }, pred -> pred.item).fieldOf("item").codec();
    }
}

