/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib;

import java.util.List;
import mekanism.common.content.transporter.TransporterPathfinder;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public record SidedBlockPos(BlockPos pos, Direction side) {
    public SidedBlockPos(BlockPos pos, Direction side) {
        this.pos = pos = pos.immutable();
        this.side = side;
    }

    public static SidedBlockPos get(TransporterPathfinder.Destination destination) {
        List<BlockPos> path = destination.getPath();
        BlockPos pos = path.get(0);
        Direction sideOfDest = WorldUtils.sideDifference(path.get(1), pos);
        return new SidedBlockPos(pos, sideOfDest);
    }

    @Nullable
    public static SidedBlockPos deserialize(CompoundTag tag) {
        if (tag.contains("x", 3) && tag.contains("y", 3) && tag.contains("z", 3) && tag.contains("side", 3)) {
            BlockPos pos = new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
            Direction side = Direction.from3DDataValue((int)tag.getInt("side"));
            return new SidedBlockPos(pos, side);
        }
        return null;
    }

    public CompoundTag serialize() {
        CompoundTag target = new CompoundTag();
        target.putInt("x", this.pos.getX());
        target.putInt("y", this.pos.getY());
        target.putInt("z", this.pos.getZ());
        NBTUtils.writeEnum(target, "side", this.side);
        return target;
    }
}

