/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.distribution;

import mekanism.common.lib.distribution.SplitInfo;

public class LongSplitInfo
extends SplitInfo<Long> {
    private long amountToSplit;
    private long amountPerTarget;
    private long sentSoFar;
    private long remainder;

    public LongSplitInfo(long amountToSplit, int totalTargets) {
        super(totalTargets);
        this.amountToSplit = amountToSplit;
        this.amountPerTarget = this.toSplitAmong == 0 ? 0L : amountToSplit / (long)this.toSplitAmong;
        this.remainder = this.toSplitAmong == 0 ? 0L : amountToSplit % (long)this.toSplitAmong;
    }

    @Override
    public void send(Long amountNeeded) {
        this.amountToSplit -= amountNeeded.longValue();
        this.sentSoFar += amountNeeded.longValue();
        if (!this.decrementTargets) {
            long difference = amountNeeded - this.amountPerTarget;
            if (difference > 0L) {
                this.remainder -= difference;
            }
            return;
        }
        --this.toSplitAmong;
        if (amountNeeded != this.amountPerTarget && this.toSplitAmong != 0) {
            long amountPerLast = this.amountPerTarget;
            this.amountPerTarget = this.amountToSplit / (long)this.toSplitAmong;
            this.remainder = this.amountToSplit % (long)this.toSplitAmong;
            if (!this.amountPerChanged && this.amountPerTarget != amountPerLast) {
                this.amountPerChanged = true;
            }
        }
    }

    @Override
    public Long getShareAmount() {
        return this.amountPerTarget;
    }

    @Override
    public Long getRemainderAmount() {
        if (this.toSplitAmong != 0 && this.remainder > 0L) {
            return this.amountPerTarget + 1L;
        }
        return this.amountPerTarget;
    }

    @Override
    public Long getUnsent() {
        return this.remainder;
    }

    @Override
    public boolean isZero(Long value) {
        return value == 0L;
    }

    @Override
    public Long getTotalSent() {
        return this.sentSoFar;
    }
}

