/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import java.util.Objects;
import java.util.UUID;
import mekanism.api.IFrequency;
import mekanism.api.security.SecurityMode;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.PacketUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Frequency
implements IFrequency {
    protected boolean dirty;
    private boolean removed;
    private String name;
    @Nullable
    private UUID ownerUUID;
    private String ownerName;
    private boolean valid = true;
    private SecurityMode securityMode = SecurityMode.PUBLIC;
    private final FrequencyType<?> frequencyType;

    public Frequency(FrequencyType<?> frequencyType, String name, @Nullable UUID uuid) {
        this(frequencyType);
        this.name = name;
        this.setOwnerUUID(uuid);
    }

    public Frequency(FrequencyType<?> frequencyType) {
        this.frequencyType = frequencyType;
    }

    public boolean tick() {
        return this.dirty;
    }

    public void onRemove() {
        this.removed = true;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean onDeactivate(BlockEntity tile) {
        return false;
    }

    public boolean update(BlockEntity tile) {
        return false;
    }

    public FrequencyType<?> getType() {
        return this.frequencyType;
    }

    public Object getKey() {
        return this.name;
    }

    @Override
    public final SecurityMode getSecurity() {
        return this.securityMode;
    }

    public void setSecurityMode(SecurityMode securityMode) {
        if (this.securityMode != securityMode) {
            this.securityMode = securityMode;
            this.dirty = true;
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.ownerUUID;
    }

    public boolean ownerMatches(UUID toCheck) {
        return Objects.equals(this.ownerUUID, toCheck);
    }

    @NotNull
    public String getOwnerName() {
        return this.ownerName;
    }

    public void writeComponentData(CompoundTag nbtTags) {
        nbtTags.putString("name", this.name);
        if (this.ownerUUID != null) {
            nbtTags.putUUID("owner", this.ownerUUID);
        }
        NBTUtils.writeEnum(nbtTags, "securityMode", this.securityMode);
    }

    public void write(CompoundTag nbtTags) {
        this.writeComponentData(nbtTags);
    }

    protected void read(CompoundTag nbtTags) {
        this.name = nbtTags.getString("name");
        NBTUtils.setUUIDIfPresent(nbtTags, "owner", this::setOwnerUUID);
        NBTUtils.setEnumIfPresent(nbtTags, "securityMode", SecurityMode::byIndexStatic, mode -> {
            this.securityMode = mode;
        });
    }

    private void setOwnerUUID(@Nullable UUID uuid) {
        this.ownerUUID = uuid;
        this.ownerName = MekanismUtils.getLastKnownUsername(this.ownerUUID);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.name);
        buffer.writeNullable((Object)this.ownerUUID, FriendlyByteBuf::writeUUID);
        buffer.writeUtf(this.ownerName, PacketUtils.LAST_USERNAME_LENGTH);
        buffer.writeEnum((Enum)this.securityMode);
    }

    protected void read(FriendlyByteBuf dataStream) {
        this.name = dataStream.readUtf();
        this.ownerUUID = (UUID)dataStream.readNullable(FriendlyByteBuf::readUUID);
        this.ownerName = dataStream.readUtf(PacketUtils.LAST_USERNAME_LENGTH);
        this.securityMode = (SecurityMode)dataStream.readEnum(SecurityMode.class);
    }

    public int getSyncHash() {
        return this.hashCode();
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.name.hashCode();
        if (this.ownerUUID != null) {
            code = 31 * code + this.ownerUUID.hashCode();
        }
        if (this.frequencyType != FrequencyType.SECURITY) {
            code = 31 * code + this.securityMode.ordinal();
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Frequency) {
            Frequency other = (Frequency)obj;
            if (this.frequencyType == FrequencyType.SECURITY || this.securityMode == other.securityMode) {
                return this.ownerUUID != null && this.name.equals(other.name) && this.ownerUUID.equals(other.ownerUUID);
            }
        }
        return false;
    }

    public FrequencyIdentity getIdentity() {
        return new FrequencyIdentity(this.getKey(), this.securityMode, this.ownerUUID);
    }

    public boolean areIdentitiesEqual(Frequency other) {
        return this.getIdentity().equals(other.getIdentity());
    }

    public CompoundTag serializeIdentity() {
        return this.frequencyType.getIdentitySerializer().serialize(this.getIdentity());
    }

    public CompoundTag serializeIdentityWithOwner() {
        CompoundTag serializedIdentity = this.serializeIdentity();
        if (!serializedIdentity.hasUUID("owner") && this.ownerUUID != null) {
            serializedIdentity.putUUID("owner", this.ownerUUID);
        }
        return serializedIdentity;
    }

    public static <FREQ extends Frequency> FREQ readFromPacket(FriendlyByteBuf dataStream) {
        return FrequencyType.load(dataStream).create(dataStream);
    }

    public record FrequencyIdentity(Object key, SecurityMode securityMode, @Nullable UUID ownerUUID) {
        public static FrequencyIdentity load(FrequencyType<?> type, CompoundTag tag) {
            return type.getIdentitySerializer().load(tag);
        }
    }
}

