/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mekanism.api.security.SecurityMode;
import mekanism.common.lib.MekanismSavedData;
import mekanism.common.lib.collection.HashList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrequencyManager<FREQ extends Frequency> {
    public static final int MAX_FREQ_LENGTH = 16;
    private static boolean loaded;
    private static final Set<FrequencyManager<?>> managers;
    private final Map<Object, FREQ> frequencies = new LinkedHashMap<Object, FREQ>();
    @Nullable
    private FrequencyDataHandler dataHandler;
    private UUID ownerUUID;
    private final FrequencyType<FREQ> frequencyType;
    private SecurityMode securityMode = SecurityMode.PUBLIC;

    public FrequencyManager(FrequencyType<FREQ> frequencyType) {
        this.frequencyType = frequencyType;
        managers.add(this);
    }

    public FrequencyManager(FrequencyType<FREQ> frequencyType, UUID uuid, SecurityMode securityMode) {
        this(frequencyType);
        this.ownerUUID = uuid;
        this.securityMode = securityMode;
    }

    public static void load() {
        if (!loaded) {
            loaded = true;
            FrequencyType.init();
            managers.forEach(FrequencyManager::createOrLoad);
        }
    }

    public static void tick() {
        if (!loaded) {
            FrequencyManager.load();
        }
        managers.forEach(FrequencyManager::tickSelf);
    }

    public static void reset() {
        for (FrequencyManager<?> manager : managers) {
            manager.frequencies.clear();
            manager.dataHandler = null;
        }
        loaded = false;
    }

    public boolean remove(Object key, UUID ownerUUID) {
        FREQ freq = this.getFrequency(key);
        if (freq != null && ((Frequency)freq).ownerMatches(ownerUUID)) {
            ((Frequency)freq).onRemove();
            this.frequencies.remove(key);
            this.markDirty();
            return true;
        }
        return false;
    }

    public void deactivate(@Nullable Frequency freq, BlockEntity tile) {
        if (freq != null && freq.onDeactivate(tile)) {
            this.markDirty();
        }
    }

    public FREQ validateAndUpdate(BlockEntity tile, FREQ freq) {
        Frequency storedFreq = (Frequency)this.frequencies.get(((Frequency)freq).getKey());
        if (storedFreq == null) {
            ((Frequency)freq).setValid(true);
            this.markDirty();
            this.frequencies.put(((Frequency)freq).getKey(), freq);
            storedFreq = freq;
        }
        if (storedFreq.update(tile)) {
            this.markDirty();
        }
        return (FREQ)storedFreq;
    }

    public void createOrLoad() {
        if (this.dataHandler == null) {
            String name = this.getName();
            this.dataHandler = MekanismSavedData.createSavedData(() -> new FrequencyDataHandler(), name);
            this.dataHandler.syncManager();
        }
    }

    public Collection<FREQ> getFrequencies() {
        if (this.securityMode == SecurityMode.TRUSTED && this.ownerUUID != null) {
            ArrayList<FREQ> trustedFrequencies = new ArrayList<FREQ>(this.frequencies.values());
            FrequencyManager<SecurityFrequency> securityManager = FrequencyType.SECURITY.getManager(null, SecurityMode.PUBLIC);
            for (FrequencyManager<FREQ> trustedManager : this.frequencyType.getManagerWrapper().getTrustedManagers()) {
                SecurityFrequency frequency;
                if (this.ownerUUID.equals(trustedManager.ownerUUID) || (frequency = securityManager.getFrequency(trustedManager.ownerUUID)) == null || !frequency.isTrusted(this.ownerUUID)) continue;
                trustedFrequencies.addAll(trustedManager.frequencies.values());
            }
            return trustedFrequencies;
        }
        return this.frequencies.values();
    }

    public FREQ getFrequency(Object key) {
        return (FREQ)((Frequency)this.frequencies.get(key));
    }

    public FREQ getOrCreateFrequency(Frequency.FrequencyIdentity identity, @Nullable UUID ownerUUID) {
        Frequency freq = (Frequency)this.frequencies.get(identity.key());
        if (freq == null) {
            freq = this.frequencyType.create(identity.key(), ownerUUID);
            freq.setSecurityMode(identity.securityMode());
            this.frequencies.put(identity.key(), freq);
            this.markDirty();
        }
        return (FREQ)freq;
    }

    public void addFrequency(FREQ freq) {
        this.frequencies.put(((Frequency)freq).getKey(), freq);
        this.markDirty();
    }

    protected void markDirty() {
        if (this.dataHandler != null) {
            this.dataHandler.setDirty();
        }
    }

    public FrequencyType<FREQ> getType() {
        return this.frequencyType;
    }

    private void tickSelf() {
        boolean dirty = false;
        for (Frequency freq : this.frequencies.values()) {
            dirty |= freq.tick();
        }
        if (dirty) {
            this.markDirty();
        }
    }

    public String getName() {
        String owner;
        String string = owner = this.ownerUUID == null ? "" : this.ownerUUID + "_";
        if (this.securityMode != SecurityMode.PUBLIC) {
            return owner + this.frequencyType.getName() + this.securityMode.name() + "FrequencyHandler";
        }
        return owner + this.frequencyType.getName() + "FrequencyHandler";
    }

    static {
        managers = new ObjectOpenHashSet();
    }

    public class FrequencyDataHandler
    extends MekanismSavedData {
        public HashList<FREQ> loadedFrequencies;
        public UUID loadedOwner;

        public void syncManager() {
            if (this.loadedFrequencies != null) {
                for (Frequency freq : this.loadedFrequencies) {
                    FrequencyManager.this.frequencies.put(freq.getKey(), freq);
                }
                FrequencyManager.this.ownerUUID = this.loadedOwner;
            }
        }

        @Override
        public void load(@NotNull CompoundTag nbtTags) {
            NBTUtils.setUUIDIfPresent(nbtTags, "owner", uuid -> {
                this.loadedOwner = uuid;
            });
            ListTag list = nbtTags.getList("freqList", 10);
            this.loadedFrequencies = new HashList();
            for (int i = 0; i < list.size(); ++i) {
                this.loadedFrequencies.add(FrequencyManager.this.frequencyType.create(list.getCompound(i)));
            }
        }

        @NotNull
        public CompoundTag save(@NotNull CompoundTag nbtTags) {
            if (FrequencyManager.this.ownerUUID != null) {
                nbtTags.putUUID("owner", FrequencyManager.this.ownerUUID);
            }
            ListTag list = new ListTag();
            for (Frequency freq : FrequencyManager.this.frequencies.values()) {
                CompoundTag compound = new CompoundTag();
                freq.write(compound);
                list.add((Object)compound);
            }
            nbtTags.put("freqList", (Tag)list);
            return nbtTags;
        }
    }
}

