/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import mekanism.api.security.SecurityMode;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyManagerWrapper;
import mekanism.common.lib.frequency.IdentitySerializer;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.lib.security.SecurityUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class FrequencyType<FREQ extends Frequency> {
    private static final Map<String, FrequencyType<?>> registryMap = new HashMap();
    private static int maxNameLength = 0;
    public static final Codec<FrequencyType<?>> CODEC = ExtraCodecs.stringResolverCodec(FrequencyType::getName, registryMap::get);
    public static final FrequencyType<TeleporterFrequency> TELEPORTER = FrequencyType.register("Teleporter", (key, uuid) -> new TeleporterFrequency((String)key, (UUID)uuid), TeleporterFrequency::new, FrequencyManagerWrapper.Type.PUBLIC_PRIVATE_TRUSTED, IdentitySerializer.NAME);
    public static final FrequencyType<InventoryFrequency> INVENTORY = FrequencyType.register("Inventory", (key, uuid) -> new InventoryFrequency((String)key, (UUID)uuid), InventoryFrequency::new, FrequencyManagerWrapper.Type.PUBLIC_PRIVATE_TRUSTED, IdentitySerializer.NAME);
    public static final FrequencyType<SecurityFrequency> SECURITY = FrequencyType.register("Security", (key, uuid) -> new SecurityFrequency((UUID)uuid), SecurityFrequency::new, FrequencyManagerWrapper.Type.PUBLIC_ONLY, IdentitySerializer.UUID);
    public static final FrequencyType<QIOFrequency> QIO = FrequencyType.register("QIO", (key, uuid) -> new QIOFrequency((String)key, (UUID)uuid), QIOFrequency::new, FrequencyManagerWrapper.Type.PUBLIC_PRIVATE_TRUSTED, IdentitySerializer.NAME);
    private final String name;
    private final BiFunction<Object, UUID, FREQ> creationFunction;
    private final Supplier<FREQ> baseCreationFunction;
    private final IdentitySerializer identitySerializer;
    private final FrequencyManagerWrapper<FREQ> managerWrapper;

    public static void init() {
    }

    private static <FREQ extends Frequency> FrequencyType<FREQ> register(String name, BiFunction<Object, UUID, FREQ> creationFunction, Supplier<FREQ> baseCreationFunction, FrequencyManagerWrapper.Type managerType, IdentitySerializer identitySerializer) {
        FrequencyType<FREQ> type = new FrequencyType<FREQ>(name, creationFunction, baseCreationFunction, managerType, identitySerializer);
        registryMap.put(name, type);
        maxNameLength = Math.max(maxNameLength, name.length());
        return type;
    }

    private FrequencyType(String name, BiFunction<Object, UUID, FREQ> creationFunction, Supplier<FREQ> baseCreationFunction, FrequencyManagerWrapper.Type managerType, IdentitySerializer identitySerializer) {
        this.name = name;
        this.creationFunction = creationFunction;
        this.baseCreationFunction = baseCreationFunction;
        this.managerWrapper = FrequencyManagerWrapper.create(this, managerType);
        this.identitySerializer = identitySerializer;
    }

    public String getName() {
        return this.name;
    }

    public FREQ create(CompoundTag tag) {
        Frequency freq = (Frequency)this.baseCreationFunction.get();
        freq.read(tag);
        return (FREQ)freq;
    }

    public FREQ create(Object key, UUID ownerUUID) {
        return (FREQ)((Frequency)this.creationFunction.apply(key, ownerUUID));
    }

    public FREQ create(FriendlyByteBuf packet) {
        Frequency freq = (Frequency)this.baseCreationFunction.get();
        freq.read(packet);
        return (FREQ)freq;
    }

    public FrequencyManagerWrapper<FREQ> getManagerWrapper() {
        return this.managerWrapper;
    }

    public FrequencyManager<FREQ> getManager(@Nullable UUID owner, SecurityMode securityMode) {
        return switch (securityMode) {
            default -> throw new IncompatibleClassChangeError();
            case SecurityMode.PUBLIC -> this.getManagerWrapper().getPublicManager();
            case SecurityMode.PRIVATE -> this.getManagerWrapper().getPrivateManager(owner);
            case SecurityMode.TRUSTED -> this.getManagerWrapper().getTrustedManager(owner);
        };
    }

    @Nullable
    @Contract(value="null -> null")
    public FrequencyManager<FREQ> getFrequencyManager(@Nullable FREQ freq) {
        if (freq == null) {
            return null;
        }
        return switch (((Frequency)freq).getSecurity()) {
            default -> throw new IncompatibleClassChangeError();
            case SecurityMode.PUBLIC -> this.getManagerWrapper().getPublicManager();
            case SecurityMode.PRIVATE -> this.getManagerWrapper().getPrivateManager(((Frequency)freq).getOwner());
            case SecurityMode.TRUSTED -> this.getManagerWrapper().getTrustedManager(((Frequency)freq).getOwner());
        };
    }

    public FrequencyManager<FREQ> getManager(Frequency.FrequencyIdentity identity, UUID owner) {
        return switch (identity.securityMode()) {
            default -> throw new IncompatibleClassChangeError();
            case SecurityMode.PUBLIC -> this.getManagerWrapper().getPublicManager();
            case SecurityMode.PRIVATE -> this.getManagerWrapper().getPrivateManager(owner);
            case SecurityMode.TRUSTED -> this.getManagerWrapper().getTrustedManager(owner);
        };
    }

    @Nullable
    public FREQ getFrequency(Frequency.FrequencyIdentity identity, UUID owner) {
        FrequencyManager<FREQ> manager = !Objects.equals(identity.ownerUUID(), owner) && SecurityUtils.get().isTrusted(identity.securityMode(), identity.ownerUUID(), owner) ? this.getManager(identity, identity.ownerUUID()) : this.getManager(identity, owner);
        return manager.getFrequency(identity.key());
    }

    public IdentitySerializer getIdentitySerializer() {
        return this.identitySerializer;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.name, maxNameLength);
    }

    public static <FREQ extends Frequency> FrequencyType<FREQ> load(FriendlyByteBuf buf) {
        return registryMap.get(buf.readUtf(maxNameLength));
    }

    public static <FREQ extends Frequency> FrequencyType<FREQ> load(CompoundTag tag) {
        return registryMap.get(tag.getString("type"));
    }

    public static void clear() {
        for (FrequencyType<?> type : registryMap.values()) {
            type.managerWrapper.clear();
        }
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (super.equals(obj)) return true;
        if (!(obj instanceof FrequencyType)) return false;
        FrequencyType other = (FrequencyType)obj;
        if (!Objects.equals(this.name, other.name)) return false;
        return true;
    }
}

