/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import java.util.UUID;
import mekanism.api.security.SecurityMode;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public interface IdentitySerializer {
    public static final IdentitySerializer NAME = new IdentitySerializer(){

        @Override
        public Frequency.FrequencyIdentity read(FriendlyByteBuf buf) {
            return new Frequency.FrequencyIdentity(buf.readUtf(), (SecurityMode)buf.readEnum(SecurityMode.class), (UUID)buf.readNullable(FriendlyByteBuf::readUUID));
        }

        @Override
        public Frequency.FrequencyIdentity load(CompoundTag data) {
            String name = data.getString("name");
            if (!name.isEmpty()) {
                SecurityMode securityMode = SecurityMode.byIndexStatic(data.getInt("securityMode"));
                if (data.hasUUID("owner")) {
                    return new Frequency.FrequencyIdentity(name, securityMode, data.getUUID("owner"));
                }
                return new Frequency.FrequencyIdentity(name, securityMode, null);
            }
            return null;
        }

        @Override
        public void write(FriendlyByteBuf buf, Frequency.FrequencyIdentity data) {
            buf.writeUtf(data.key().toString());
            buf.writeEnum((Enum)data.securityMode());
            buf.writeNullable((Object)data.ownerUUID(), FriendlyByteBuf::writeUUID);
        }

        @Override
        public CompoundTag serialize(Frequency.FrequencyIdentity data) {
            CompoundTag tag = new CompoundTag();
            tag.putString("name", data.key().toString());
            NBTUtils.writeEnum(tag, "securityMode", data.securityMode());
            if (data.ownerUUID() != null) {
                tag.putUUID("owner", data.ownerUUID());
            }
            return tag;
        }
    };
    public static final IdentitySerializer UUID = new IdentitySerializer(){

        @Override
        public Frequency.FrequencyIdentity read(FriendlyByteBuf buf) {
            UUID owner = buf.readUUID();
            return new Frequency.FrequencyIdentity(owner, (SecurityMode)buf.readEnum(SecurityMode.class), owner);
        }

        @Override
        public Frequency.FrequencyIdentity load(CompoundTag data) {
            if (data.hasUUID("owner")) {
                UUID owner = data.getUUID("owner");
                return new Frequency.FrequencyIdentity(owner, SecurityMode.byIndexStatic(data.getInt("publicFreq")), owner);
            }
            return null;
        }

        @Override
        public void write(FriendlyByteBuf buf, Frequency.FrequencyIdentity data) {
            buf.writeUUID((UUID)data.key());
            buf.writeEnum((Enum)data.securityMode());
        }

        @Override
        public CompoundTag serialize(Frequency.FrequencyIdentity data) {
            CompoundTag tag = new CompoundTag();
            tag.putUUID("owner", (UUID)data.key());
            NBTUtils.writeEnum(tag, "securityMode", data.securityMode());
            return tag;
        }
    };

    public Frequency.FrequencyIdentity read(FriendlyByteBuf var1);

    public Frequency.FrequencyIdentity load(CompoundTag var1);

    public void write(FriendlyByteBuf var1, Frequency.FrequencyIdentity var2);

    public CompoundTag serialize(Frequency.FrequencyIdentity var1);
}

