/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import mekanism.api.security.SecurityMode;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.list.SyncableFrequencyList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.lib.security.SecurityUtils;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileComponentFrequency
implements ITileComponent {
    private static final AtomicInteger OFFSET = new AtomicInteger(0);
    private final TileEntityMekanism tile;
    private Map<FrequencyType<?>, FrequencyData> nonSecurityFrequencies = Collections.emptyMap();
    @Nullable
    private FrequencyData securityFrequency = null;
    private final Map<SecurityMode, Map<FrequencyType<?>, List<? extends Frequency>>> frequencyCache = new EnumMap(SecurityMode.class);
    private final int tickOffset;
    private boolean needsSave;
    private boolean needsNotify;

    public TileComponentFrequency(TileEntityMekanism tile) {
        this.tile = tile;
        this.tickOffset = OFFSET.getAndIncrement() % 5;
        tile.addComponent(this);
    }

    public boolean hasCustomFrequencies() {
        return !this.nonSecurityFrequencies.isEmpty();
    }

    public Set<FrequencyType<?>> getCustomFrequencies() {
        return this.nonSecurityFrequencies.keySet();
    }

    public void tickServer(Level level, BlockPos pos) {
        if (level.getServer().getTickCount() % 5 == this.tickOffset) {
            if (this.securityFrequency != null) {
                this.updateFrequency(FrequencyType.SECURITY, this.securityFrequency);
            }
            for (Map.Entry<FrequencyType<?>, FrequencyData> entry : this.nonSecurityFrequencies.entrySet()) {
                this.updateFrequency(entry.getKey(), entry.getValue());
            }
        }
        if (this.needsNotify) {
            this.tile.invalidateCapabilitiesFull();
            WorldUtils.notifyLoadedNeighborsOfTileChange(level, pos);
            this.needsNotify = false;
        }
        if (this.needsSave) {
            this.tile.setChanged();
            this.needsSave = false;
        }
    }

    public void track(FrequencyType<?> type, boolean needsSync, boolean needsListCache, boolean notifyNeighbors) {
        FrequencyData value = new FrequencyData(needsSync, needsListCache, notifyNeighbors);
        if (type == FrequencyType.SECURITY) {
            this.securityFrequency = value;
        } else if (this.nonSecurityFrequencies.isEmpty()) {
            this.nonSecurityFrequencies = Collections.singletonMap(type, value);
        } else if (this.nonSecurityFrequencies.size() == 1) {
            this.nonSecurityFrequencies = new Object2ObjectArrayMap(this.nonSecurityFrequencies);
            this.nonSecurityFrequencies.put(type, value);
        } else {
            this.nonSecurityFrequencies.put(type, value);
        }
    }

    @Nullable
    public <FREQ extends Frequency> FREQ getFrequency(FrequencyType<FREQ> type) {
        FrequencyData frequencyData = this.getFrequencyData(type);
        if (frequencyData == null) {
            return null;
        }
        return (FREQ)frequencyData.selectedFrequency;
    }

    @Nullable
    private <FREQ extends Frequency> FrequencyData getFrequencyData(FrequencyType<FREQ> type) {
        return type == FrequencyType.SECURITY ? this.securityFrequency : this.nonSecurityFrequencies.get(type);
    }

    public <FREQ extends Frequency> void unsetFrequency(FrequencyType<FREQ> type) {
        this.unsetFrequency(type, this.getFrequencyData(type));
    }

    private <FREQ extends Frequency> void unsetFrequency(FrequencyType<FREQ> type, FrequencyData frequencyData) {
        if (frequencyData != null && frequencyData.selectedFrequency != null) {
            this.deactivate(type, frequencyData);
            frequencyData.clearFrequency();
            this.setNeedsNotify(frequencyData);
        }
    }

    public <FREQ extends Frequency> List<FREQ> getPublicCache(FrequencyType<FREQ> type) {
        return this.getCache(SecurityMode.PUBLIC, type);
    }

    public <FREQ extends Frequency> List<FREQ> getPrivateCache(FrequencyType<FREQ> type) {
        return this.getCache(SecurityMode.PRIVATE, type);
    }

    public <FREQ extends Frequency> List<FREQ> getTrustedCache(FrequencyType<FREQ> type) {
        return this.getCache(SecurityMode.TRUSTED, type);
    }

    private Map<FrequencyType<?>, List<? extends Frequency>> getCache(SecurityMode securityMode) {
        return this.frequencyCache.computeIfAbsent(securityMode, mode -> new LinkedHashMap());
    }

    private <FREQ extends Frequency> List<FREQ> getCache(SecurityMode securityMode, FrequencyType<FREQ> type) {
        return this.getCache(securityMode).computeIfAbsent(type, t -> new ArrayList());
    }

    public <FREQ extends Frequency> void setFrequencyFromData(FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, UUID player) {
        FrequencyData frequencyData;
        if (player != null && (frequencyData = this.getFrequencyData(type)) != null) {
            this.setFrequencyFromData(type, data, player, frequencyData);
        }
    }

    private <FREQ extends Frequency> void setFrequencyFromData(FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, @NotNull UUID player, FrequencyData frequencyData) {
        Frequency oldFrequency = frequencyData.selectedFrequency;
        FrequencyManager<FREQ> manager = null;
        Frequency freq = null;
        if (!Objects.equals(data.ownerUUID(), player) && SecurityUtils.get().isTrusted(data.securityMode(), data.ownerUUID(), player) && (freq = (manager = type.getManager(data, data.ownerUUID())).getFrequency(data.key())) == null) {
            data = new Frequency.FrequencyIdentity(data.key(), data.securityMode(), player);
        }
        if (freq == null) {
            manager = type.getManager(data, player);
            freq = manager.getOrCreateFrequency(data, player);
        }
        if (!freq.equals(oldFrequency)) {
            manager.deactivate(oldFrequency, this.tile);
            freq.update(this.tile);
            frequencyData.setFrequency(freq);
            this.setNeedsNotify(frequencyData);
        }
    }

    public void removeFrequencyFromData(FrequencyType<?> type, Frequency.FrequencyIdentity data, UUID player) {
        FrequencyData frequencyData;
        FrequencyManager<?> manager = type.getManager(data, data.ownerUUID() == null ? player : data.ownerUUID());
        if (manager != null && manager.remove(data.key(), player) && (frequencyData = this.getFrequencyData(type)) != null) {
            this.setNeedsNotify(frequencyData);
        }
    }

    private <FREQ extends Frequency> void updateFrequency(FrequencyType<FREQ> type, FrequencyData frequencyData) {
        if (frequencyData.selectedFrequency != null) {
            if (frequencyData.selectedFrequency.isValid()) {
                UUID ownerUUID;
                boolean unsetFrequency = frequencyData.selectedFrequency.isRemoved();
                if (!unsetFrequency && frequencyData.selectedFrequency.getSecurity() == SecurityMode.TRUSTED && (ownerUUID = this.tile.getOwnerUUID()) != null && !frequencyData.selectedFrequency.ownerMatches(ownerUUID)) {
                    SecurityFrequency security = FrequencyType.SECURITY.getManager(null, SecurityMode.PUBLIC).getFrequency(frequencyData.selectedFrequency.getOwner());
                    boolean bl = unsetFrequency = security != null && !security.isTrusted(ownerUUID);
                }
                if (unsetFrequency) {
                    FrequencyManager<Frequency> manager = type.getFrequencyManager(frequencyData.selectedFrequency);
                    if (manager != null) {
                        manager.deactivate(frequencyData.selectedFrequency, this.tile);
                    }
                    frequencyData.clearFrequency();
                    this.setNeedsNotify(frequencyData);
                }
            } else {
                Frequency frequency = frequencyData.selectedFrequency;
                FrequencyManager<Frequency> manager = type.getFrequencyManager(frequency);
                if (manager == null) {
                    frequencyData.clearFrequency();
                } else {
                    frequencyData.setFrequency(manager.validateAndUpdate(this.tile, frequency));
                }
                this.setNeedsNotify(frequencyData);
            }
        }
    }

    private void setNeedsNotify(FrequencyData data) {
        if (data.notifyNeighbors) {
            this.needsNotify = true;
        }
        this.needsSave = true;
    }

    private <FREQ extends Frequency> void deactivate(FrequencyType<FREQ> type, FrequencyData frequencyData) {
        FrequencyManager<Frequency> manager;
        if (frequencyData.selectedFrequency != null && (manager = type.getFrequencyManager(frequencyData.selectedFrequency)) != null) {
            manager.deactivate(frequencyData.selectedFrequency, this.tile);
        }
    }

    @Override
    public String getComponentKey() {
        return "componentFrequency";
    }

    @Override
    public void deserialize(CompoundTag frequencyNBT) {
        if (this.securityFrequency != null) {
            TileComponentFrequency.deserializeFrequency(frequencyNBT, FrequencyType.SECURITY, this.securityFrequency);
        }
        for (Map.Entry<FrequencyType<?>, FrequencyData> entry : this.nonSecurityFrequencies.entrySet()) {
            FrequencyType<?> type = entry.getKey();
            TileComponentFrequency.deserializeFrequency(frequencyNBT, type, entry.getValue());
        }
    }

    private static void deserializeFrequency(CompoundTag frequencyNBT, FrequencyType<?> type, FrequencyData frequencyData) {
        if (frequencyNBT.contains(type.getName(), 10)) {
            Object frequency = type.create(frequencyNBT.getCompound(type.getName()));
            ((Frequency)frequency).setValid(false);
            frequencyData.setFrequency((Frequency)frequency);
        }
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag frequencyNBT = new CompoundTag();
        if (this.securityFrequency != null) {
            TileComponentFrequency.serializeFrequency(this.securityFrequency, frequencyNBT);
        }
        for (FrequencyData frequencyData : this.nonSecurityFrequencies.values()) {
            TileComponentFrequency.serializeFrequency(frequencyData, frequencyNBT);
        }
        return frequencyNBT;
    }

    private static void serializeFrequency(FrequencyData frequencyData, CompoundTag frequencyNBT) {
        Frequency frequency = frequencyData.selectedFrequency;
        if (frequency != null) {
            CompoundTag frequencyTag = new CompoundTag();
            frequency.writeComponentData(frequencyTag);
            frequencyNBT.put(frequency.getType().getName(), (Tag)frequencyTag);
        }
    }

    public void readConfiguredFrequencies(Player player, CompoundTag data) {
        if (this.hasCustomFrequencies() && data.contains(this.getComponentKey(), 10)) {
            CompoundTag frequencyNBT = data.getCompound(this.getComponentKey());
            for (Map.Entry<FrequencyType<?>, FrequencyData> entry : this.nonSecurityFrequencies.entrySet()) {
                Frequency.FrequencyIdentity identity;
                CompoundTag frequencyData;
                FrequencyType<?> type = entry.getKey();
                if (type == FrequencyType.SECURITY) continue;
                if (frequencyNBT.contains(type.getName(), 10) && (frequencyData = frequencyNBT.getCompound(type.getName())).hasUUID("owner") && (identity = Frequency.FrequencyIdentity.load(type, frequencyData)) != null) {
                    UUID owner = frequencyData.getUUID("owner");
                    if (identity.securityMode() != SecurityMode.PUBLIC && !owner.equals(player.getUUID())) continue;
                    this.setFrequencyFromData(type, identity, owner, entry.getValue());
                    continue;
                }
                this.unsetFrequency(type, entry.getValue());
            }
        }
    }

    public void writeConfiguredFrequencies(CompoundTag data) {
        CompoundTag frequencyNBT = new CompoundTag();
        for (Map.Entry<FrequencyType<?>, FrequencyData> entry : this.nonSecurityFrequencies.entrySet()) {
            Frequency frequency = entry.getValue().selectedFrequency;
            if (frequency == null || entry.getKey() == FrequencyType.SECURITY) continue;
            frequencyNBT.put(entry.getKey().getName(), (Tag)frequency.serializeIdentityWithOwner());
        }
        if (!frequencyNBT.isEmpty()) {
            data.put(this.getComponentKey(), (Tag)frequencyNBT);
        }
    }

    @Override
    public void invalidate() {
        if (!this.tile.isRemote()) {
            for (Map.Entry<FrequencyType<?>, FrequencyData> entry : this.nonSecurityFrequencies.entrySet()) {
                this.deactivate(entry.getKey(), entry.getValue());
            }
            if (this.securityFrequency != null) {
                this.deactivate(FrequencyType.SECURITY, this.securityFrequency);
            }
        }
    }

    @Override
    public void trackForMainContainer(MekanismContainer container) {
        if (this.securityFrequency != null) {
            this.trackFrequencyForMainContainer(container, this.securityFrequency, FrequencyType.SECURITY);
        }
        for (Map.Entry<FrequencyType<?>, FrequencyData> entry : this.nonSecurityFrequencies.entrySet()) {
            FrequencyData data = entry.getValue();
            this.trackFrequencyForMainContainer(container, data, entry.getKey());
        }
    }

    private void trackFrequencyForMainContainer(MekanismContainer container, FrequencyData data, FrequencyType<?> key) {
        if (data.needsContainerSync) {
            container.track(SyncableFrequency.create(key, () -> data.selectedFrequency, data::setFrequency));
        }
        if (data.needsListCache) {
            this.track(container, key);
        }
    }

    private <FREQ extends Frequency> Consumer<@NotNull List<FREQ>> getSetter(SecurityMode securityMode, FrequencyType<FREQ> type) {
        Map<FrequencyType<?>, List<? extends Frequency>> cache = this.getCache(securityMode);
        return value -> cache.put(type, (List<? extends Frequency>)value);
    }

    private <FREQ extends Frequency> void track(MekanismContainer container, FrequencyType<FREQ> type) {
        Consumer<@NotNull List<FREQUENCY>> publicSetter = this.getSetter(SecurityMode.PUBLIC, type);
        Consumer<@NotNull List<FREQUENCY>> privateSetter = this.getSetter(SecurityMode.PRIVATE, type);
        Consumer<@NotNull List<FREQUENCY>> trustedSetter = this.getSetter(SecurityMode.TRUSTED, type);
        if (container.isRemote()) {
            container.track(SyncableFrequencyList.create(type, () -> this.getPublicCache(type), publicSetter));
            container.track(SyncableFrequencyList.create(type, () -> this.getPrivateCache(type), privateSetter));
            container.track(SyncableFrequencyList.create(type, () -> this.getTrustedCache(type), trustedSetter));
        } else {
            container.track(SyncableFrequencyList.create(type, () -> type.getManagerWrapper().getPublicManager().getFrequencies(), publicSetter));
            container.track(SyncableFrequencyList.create(type, () -> type.getManagerWrapper().getPrivateManager(container.getPlayerUUID()).getFrequencies(), privateSetter));
            container.track(SyncableFrequencyList.create(type, () -> type.getManagerWrapper().getTrustedManager(container.getPlayerUUID()).getFrequencies(), trustedSetter));
        }
    }

    private static final class FrequencyData {
        private final boolean needsContainerSync;
        private final boolean needsListCache;
        private final boolean notifyNeighbors;
        @Nullable
        private Frequency selectedFrequency;

        private FrequencyData(boolean needsContainerSync, boolean needsListCache, boolean notifyNeighbors) {
            this.needsContainerSync = needsContainerSync;
            this.needsListCache = needsListCache;
            this.notifyNeighbors = notifyNeighbors;
        }

        public void setFrequency(@Nullable Frequency frequency) {
            this.selectedFrequency = frequency;
        }

        public void clearFrequency() {
            this.setFrequency(null);
        }
    }
}

