/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.inventory;

import java.util.function.Predicate;
import mekanism.common.lib.WildcardMatcher;
import mekanism.common.util.MekanismUtils;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@FunctionalInterface
public interface Finder
extends Predicate<ItemStack> {
    public static final Finder ANY = stack -> true;
    public static final Finder NONE = stack -> false;

    public static Finder item(Item itemType) {
        if (itemType == Items.AIR) {
            return NONE;
        }
        return stack -> stack.is(itemType);
    }

    public static Finder item(ItemStack itemType) {
        return Finder.item(itemType.getItem());
    }

    public static Finder strict(ItemStack itemType) {
        return stack -> ItemHandlerHelper.canItemStacksStack((ItemStack)itemType, (ItemStack)stack);
    }

    public static Finder tag(String tagName) {
        return stack -> !stack.isEmpty() && stack.getTags().anyMatch(tag -> WildcardMatcher.matches(tagName, tag));
    }

    public static Finder modID(String modID) {
        return stack -> !stack.isEmpty() && WildcardMatcher.matches(modID, MekanismUtils.getModId(stack));
    }
}

