/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.inventory;

import java.util.Objects;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.inventory.IHashedItem;
import mekanism.common.util.StackUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class HashedItem
implements IHashedItem {
    private final ItemStack itemStack;
    private final int hashCode;

    public static HashedItem create(ItemStack stack) {
        return new HashedItem(stack.copyWithCount(1));
    }

    public static HashedItem raw(ItemStack stack) {
        return new HashedItem(stack);
    }

    protected HashedItem(ItemStack stack) {
        this.itemStack = stack;
        this.hashCode = this.initHashCode();
    }

    protected HashedItem(HashedItem other) {
        this(other.itemStack, other.hashCode);
    }

    protected HashedItem(ItemStack stack, int hashCode) {
        this.itemStack = stack;
        this.hashCode = hashCode;
    }

    @Override
    public ItemStack getInternalStack() {
        return this.itemStack;
    }

    @Override
    public ItemStack createStack(int size) {
        return StackUtils.size(this.itemStack, size);
    }

    public HashedItem recreate() {
        return new HashedItem(this.createStack(1), this.hashCode);
    }

    @NotNull
    public CompoundTag internalToNBT() {
        CompoundTag stackTag = new CompoundTag();
        this.itemStack.save(stackTag);
        return stackTag;
    }

    public boolean equals(Object obj) {
        IHashedItem other;
        if (obj == this) {
            return true;
        }
        return obj instanceof IHashedItem && ItemHandlerHelper.canItemStacksStack((ItemStack)this.itemStack, (ItemStack)(other = (IHashedItem)obj).getInternalStack());
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int initHashCode() {
        CompoundTag attachments;
        int code = this.itemStack.getItem().hashCode();
        if (this.itemStack.hasTag()) {
            code = 31 * code + this.itemStack.getTag().hashCode();
        }
        if ((attachments = this.itemStack.serializeAttachments()) != null) {
            code = 31 * code + attachments.hashCode();
        }
        return code;
    }

    public static class UUIDAwareHashedItem
    extends HashedItem {
        @Nullable
        private final UUID uuid;
        private final int uuidBasedHash;
        private final boolean overrideHash;

        public UUIDAwareHashedItem(ItemStack stack, @Nullable UUID uuid) {
            super(stack.copyWithCount(1));
            this.uuid = uuid;
            if (this.uuid == null) {
                this.overrideHash = false;
                this.uuidBasedHash = super.hashCode();
            } else {
                this.overrideHash = true;
                this.uuidBasedHash = Objects.hash(super.hashCode(), this.uuid);
            }
        }

        public UUIDAwareHashedItem(HashedItem other, @NotNull UUID uuid) {
            super(other);
            this.uuid = uuid;
            this.uuidBasedHash = super.hashCode();
            this.overrideHash = false;
        }

        @Nullable
        public UUID getUUID() {
            return this.uuid;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.overrideHash) return super.equals(obj);
            if (!(obj instanceof UUIDAwareHashedItem)) return false;
            UUIDAwareHashedItem uuidAware = (UUIDAwareHashedItem)obj;
            if (!this.uuid.equals(uuidAware.uuid)) return false;
            if (!super.equals(obj)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.uuidBasedHash;
        }

        public HashedItem asRawHashedItem() {
            return new HashedItem(this);
        }
    }
}

