/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.inventory.personalstorage;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.security.IItemSecurityUtils;
import mekanism.common.Mekanism;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.lib.MekanismSavedData;
import mekanism.common.lib.inventory.personalstorage.AbstractPersonalStorageItemInventory;
import mekanism.common.lib.inventory.personalstorage.PersonalStorageData;
import mekanism.common.registries.MekanismAttachmentTypes;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.util.thread.EffectiveSide;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNotNullByDefault
public class PersonalStorageManager {
    private static final Map<UUID, PersonalStorageData> STORAGE_BY_PLAYER_UUID = new HashMap<UUID, PersonalStorageData>();

    private static Optional<PersonalStorageData> forOwner(UUID playerUUID) {
        if (EffectiveSide.get().isClient()) {
            return Optional.empty();
        }
        return Optional.of(STORAGE_BY_PLAYER_UUID.computeIfAbsent(playerUUID, uuid -> MekanismSavedData.createSavedData(PersonalStorageData::new, "personal_storage" + File.separator + uuid)));
    }

    public static Optional<AbstractPersonalStorageItemInventory> getInventoryFor(ItemStack stack) {
        UUID owner = IItemSecurityUtils.INSTANCE.getOwnerUUID(stack);
        if (owner == null) {
            Mekanism.logger.error("Storage inventory asked for but stack has no owner! {}", (Object)stack, (Object)new Exception());
            return Optional.empty();
        }
        UUID invId = PersonalStorageManager.getInventoryId(stack);
        Optional<PersonalStorageData> data = PersonalStorageManager.forOwner(owner);
        if (data.isPresent()) {
            return Optional.of(data.get().getOrAddInventory(invId));
        }
        return Optional.empty();
    }

    public static boolean createInventoryFor(ItemStack stack, List<IInventorySlot> contents) {
        UUID owner = IItemSecurityUtils.INSTANCE.getOwnerUUID(stack);
        if (owner == null || contents.size() != 54) {
            return false;
        }
        Optional<PersonalStorageData> data = PersonalStorageManager.forOwner(owner);
        if (data.isPresent()) {
            data.get().addInventory(PersonalStorageManager.getInventoryId(stack), contents);
        }
        return true;
    }

    public static Optional<AbstractPersonalStorageItemInventory> getInventoryIfPresent(ItemStack stack) {
        UUID owner = IItemSecurityUtils.INSTANCE.getOwnerUUID(stack);
        return owner != null && stack.hasData(MekanismAttachmentTypes.PERSONAL_STORAGE_ID) ? PersonalStorageManager.getInventoryFor(stack) : Optional.empty();
    }

    public static void deleteInventory(ItemStack stack) {
        Optional<PersonalStorageData> data;
        UUID storageId;
        UUID owner = IItemSecurityUtils.INSTANCE.getOwnerUUID(stack);
        if (owner != null && (storageId = (UUID)stack.removeData(MekanismAttachmentTypes.PERSONAL_STORAGE_ID)) != null && (data = PersonalStorageManager.forOwner(owner)).isPresent()) {
            data.get().removeInventory(storageId);
        }
    }

    @NotNull
    private static UUID getInventoryId(ItemStack stack) {
        Optional existingData = stack.getExistingData(MekanismAttachmentTypes.PERSONAL_STORAGE_ID);
        if (existingData.isPresent()) {
            return (UUID)existingData.get();
        }
        UUID invId = UUID.randomUUID();
        stack.setData(MekanismAttachmentTypes.PERSONAL_STORAGE_ID, (Object)invId);
        return invId;
    }

    public static void reset() {
        STORAGE_BY_PLAYER_UUID.clear();
    }

    public static void createSlots(Consumer<IInventorySlot> slotConsumer, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInteract, @Nullable IContentsListener listener) {
        for (int slotY = 0; slotY < 6; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                slotConsumer.accept(BasicInventorySlot.at(canInteract, canInteract, listener, 8 + slotX * 18, 18 + slotY * 18));
            }
        }
    }
}

