/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.math.voxel;

import mekanism.common.lib.math.voxel.BlockPosBuilder;
import mekanism.common.lib.math.voxel.IShape;
import mekanism.common.lib.math.voxel.VoxelPlane;
import mekanism.common.lib.multiblock.Structure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;

public class VoxelCuboid
implements IShape {
    private BlockPos minPos;
    private BlockPos maxPos;
    private AABB asAABB;

    public VoxelCuboid(BlockPos minPos, BlockPos maxPos) {
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.asAABB = AABB.encapsulatingFullBlocks((BlockPos)minPos, (BlockPos)maxPos);
    }

    public VoxelCuboid(int length, int height, int width) {
        this(BlockPos.ZERO, new BlockPos(length - 1, height - 1, width - 1));
    }

    public int length() {
        return this.maxPos.getX() - this.minPos.getX() + 1;
    }

    public int width() {
        return this.maxPos.getZ() - this.minPos.getZ() + 1;
    }

    public int height() {
        return this.maxPos.getY() - this.minPos.getY() + 1;
    }

    public BlockPos getMinPos() {
        return this.minPos;
    }

    public BlockPos getMaxPos() {
        return this.maxPos;
    }

    public void setMinPos(BlockPos minPos) {
        this.minPos = minPos;
        this.asAABB = AABB.encapsulatingFullBlocks((BlockPos)minPos, (BlockPos)this.maxPos);
    }

    public void setMaxPos(BlockPos maxPos) {
        this.maxPos = maxPos;
        this.asAABB = AABB.encapsulatingFullBlocks((BlockPos)this.minPos, (BlockPos)maxPos);
    }

    public BlockPos getCenter() {
        return new BlockPos((this.minPos.getX() + this.maxPos.getX()) / 2, (this.minPos.getY() + this.maxPos.getY()) / 2, (this.minPos.getZ() + this.maxPos.getZ()) / 2);
    }

    public Direction getSide(BlockPos pos) {
        if (pos.getX() == this.minPos.getX()) {
            return Direction.WEST;
        }
        if (pos.getX() == this.maxPos.getX()) {
            return Direction.EAST;
        }
        if (pos.getZ() == this.minPos.getZ()) {
            return Direction.NORTH;
        }
        if (pos.getZ() == this.maxPos.getZ()) {
            return Direction.SOUTH;
        }
        if (pos.getY() == this.minPos.getY()) {
            return Direction.DOWN;
        }
        if (pos.getY() == this.maxPos.getY()) {
            return Direction.UP;
        }
        return null;
    }

    public boolean isOnSide(BlockPos pos) {
        return this.getWallRelative(pos).isWall();
    }

    public boolean isOnEdge(BlockPos pos) {
        return this.getWallRelative(pos).isOnEdge();
    }

    public boolean isOnCorner(BlockPos pos) {
        return this.getWallRelative(pos).isOnCorner();
    }

    public WallRelative getWallRelative(BlockPos pos) {
        int matches = this.getMatches(pos);
        if (matches >= 3) {
            return WallRelative.CORNER;
        }
        if (matches == 2) {
            return WallRelative.EDGE;
        }
        if (matches == 1) {
            return WallRelative.SIDE;
        }
        return WallRelative.INVALID;
    }

    public int getMatches(BlockPos pos) {
        int matches = 0;
        if (pos.getX() == this.minPos.getX()) {
            ++matches;
        }
        if (pos.getX() == this.maxPos.getX()) {
            ++matches;
        }
        if (pos.getY() == this.minPos.getY()) {
            ++matches;
        }
        if (pos.getY() == this.maxPos.getY()) {
            ++matches;
        }
        if (pos.getZ() == this.minPos.getZ()) {
            ++matches;
        }
        if (pos.getZ() == this.maxPos.getZ()) {
            ++matches;
        }
        return matches;
    }

    public CuboidRelative getRelativeLocation(BlockPos pos) {
        if (pos.getX() > this.minPos.getX() && pos.getX() < this.maxPos.getX() && pos.getY() > this.minPos.getY() && pos.getY() < this.maxPos.getY() && pos.getZ() > this.minPos.getZ() && pos.getZ() < this.maxPos.getZ()) {
            return CuboidRelative.INSIDE;
        }
        if (pos.getX() < this.minPos.getX() || pos.getX() > this.maxPos.getX() || pos.getY() < this.minPos.getY() || pos.getY() > this.maxPos.getY() || pos.getZ() < this.minPos.getZ() || pos.getZ() > this.maxPos.getZ()) {
            return CuboidRelative.OUTSIDE;
        }
        return CuboidRelative.WALLS;
    }

    public boolean greaterOrEqual(VoxelCuboid other) {
        return this.length() >= other.length() && this.width() >= other.width() && this.height() >= other.height();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.maxPos.hashCode();
        result = 31 * result + this.minPos.hashCode();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof VoxelCuboid)) return false;
        VoxelCuboid other = (VoxelCuboid)obj;
        if (!this.minPos.equals((Object)other.minPos)) return false;
        if (!this.maxPos.equals((Object)other.maxPos)) return false;
        return true;
    }

    public static VoxelCuboid from(VoxelPlane p1, VoxelPlane p2, int p1Pos, int p2Pos) {
        BlockPosBuilder min = new BlockPosBuilder();
        BlockPosBuilder max = new BlockPosBuilder();
        p1.getAxis().set(min, p1Pos);
        p2.getAxis().set(max, p2Pos);
        p1.getAxis().horizontal().set(min, p1.getMinCol());
        p1.getAxis().horizontal().set(max, p1.getMaxCol());
        p1.getAxis().vertical().set(min, p1.getMinRow());
        p1.getAxis().vertical().set(max, p1.getMaxRow());
        return new VoxelCuboid(min.build(), max.build());
    }

    public String toString() {
        return "Cuboid(start=" + this.minPos + ", bounds=(" + this.length() + "," + this.height() + "," + this.width() + "))";
    }

    public AABB asAABB() {
        return this.asAABB;
    }

    public static enum WallRelative {
        SIDE,
        EDGE,
        CORNER,
        INVALID;


        public boolean isWall() {
            return this != INVALID;
        }

        public boolean isOnEdge() {
            return this == EDGE || this == CORNER;
        }

        public boolean isOnCorner() {
            return this == CORNER;
        }
    }

    public static enum CuboidRelative {
        INSIDE,
        OUTSIDE,
        WALLS;


        public boolean isWall() {
            return this == WALLS;
        }
    }

    public static class CuboidBuilder {
        private final BlockPosBuilder[] bounds = new BlockPosBuilder[]{new BlockPosBuilder(), new BlockPosBuilder()};

        public boolean isSet(CuboidSide side) {
            return this.bounds[side.getFace().ordinal()].isSet(side.getAxis());
        }

        public void set(CuboidSide side, int val) {
            this.bounds[side.getFace().ordinal()].set(side.getAxis(), val);
        }

        public boolean trySet(CuboidSide side, int val) {
            if (this.isSet(side) && this.get(side) != val) {
                return false;
            }
            this.set(side, val);
            return true;
        }

        public int get(CuboidSide side) {
            return this.bounds[side.getFace().ordinal()].get(side.getAxis());
        }

        public VoxelCuboid build() {
            return new VoxelCuboid(this.bounds[0].build(), this.bounds[1].build());
        }
    }

    public static enum CuboidSide {
        BOTTOM(Structure.Axis.Y, Face.NEGATIVE),
        TOP(Structure.Axis.Y, Face.POSITIVE),
        NORTH(Structure.Axis.Z, Face.NEGATIVE),
        SOUTH(Structure.Axis.Z, Face.POSITIVE),
        WEST(Structure.Axis.X, Face.NEGATIVE),
        EAST(Structure.Axis.X, Face.POSITIVE);

        public static final CuboidSide[] SIDES;
        private static final CuboidSide[][] ORDERED;
        private static final CuboidSide[] OPPOSITES;
        private final Structure.Axis axis;
        private final Face face;

        private CuboidSide(Structure.Axis axis, Face face) {
            this.axis = axis;
            this.face = face;
        }

        public Structure.Axis getAxis() {
            return this.axis;
        }

        public Face getFace() {
            return this.face;
        }

        public CuboidSide flip() {
            return OPPOSITES[this.ordinal()];
        }

        public static CuboidSide get(Face face, Structure.Axis axis) {
            return ORDERED[face.ordinal()][axis.ordinal()];
        }

        static {
            SIDES = CuboidSide.values();
            ORDERED = new CuboidSide[][]{{WEST, BOTTOM, NORTH}, {EAST, TOP, SOUTH}};
            OPPOSITES = new CuboidSide[]{TOP, BOTTOM, SOUTH, NORTH, EAST, WEST};
        }

        public static enum Face {
            NEGATIVE,
            POSITIVE;


            public Face getOpposite() {
                return this == POSITIVE ? NEGATIVE : POSITIVE;
            }

            public boolean isPositive() {
                return this == POSITIVE;
            }
        }
    }
}

