/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.util.Set;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.lib.math.voxel.VoxelPlane;
import mekanism.common.lib.multiblock.Structure;

public class StructureHelper {
    private StructureHelper() {
    }

    public static VoxelCuboid fetchCuboid(Structure structure, VoxelCuboid minBounds, VoxelCuboid maxBounds) {
        VoxelCuboid prev = null;
        for (Structure.Axis axis : Structure.Axis.AXES) {
            ObjectSortedSet majorAxisMap = structure.getMajorAxisMap(axis).int2ObjectEntrySet();
            Int2ObjectMap.Entry firstMajor = (Int2ObjectMap.Entry)majorAxisMap.first();
            Int2ObjectMap.Entry lastMajor = (Int2ObjectMap.Entry)majorAxisMap.last();
            if (firstMajor == null || !((VoxelPlane)firstMajor.getValue()).equals(lastMajor.getValue()) || !((VoxelPlane)firstMajor.getValue()).isFull()) {
                return null;
            }
            VoxelCuboid cuboid = VoxelCuboid.from((VoxelPlane)firstMajor.getValue(), (VoxelPlane)lastMajor.getValue(), firstMajor.getIntKey(), lastMajor.getIntKey());
            if (!(prev != null || cuboid.greaterOrEqual(minBounds) && maxBounds.greaterOrEqual(cuboid))) {
                return null;
            }
            if (prev != null && !prev.equals(cuboid)) {
                return null;
            }
            Int2ObjectSortedMap<VoxelPlane> minorAxisMap = structure.getMinorAxisMap(axis);
            if (!minorAxisMap.isEmpty() && (StructureHelper.hasOutOfBoundsNegativeMinor(minorAxisMap, firstMajor.getIntKey()) || StructureHelper.hasOutOfBoundsPositiveMinor(minorAxisMap, lastMajor.getIntKey()))) {
                return null;
            }
            prev = cuboid;
        }
        return prev;
    }

    public static VoxelCuboid fetchCuboid(Structure structure, VoxelCuboid minBounds, VoxelCuboid maxBounds, Set<VoxelCuboid.CuboidSide> sides, int tolerance) {
        if (sides.size() < 2) {
            return null;
        }
        int missing = 0;
        VoxelCuboid.CuboidBuilder builder = new VoxelCuboid.CuboidBuilder();
        for (VoxelCuboid.CuboidSide side : sides) {
            Int2ObjectMap.Entry majorEntry;
            Structure.Axis axis = side.getAxis();
            Structure.Axis horizontal = axis.horizontal();
            Structure.Axis vertical = axis.vertical();
            ObjectSortedSet majorAxisMap = structure.getMajorAxisMap(axis).int2ObjectEntrySet();
            Int2ObjectMap.Entry entry = majorEntry = side.getFace().isPositive() ? (Int2ObjectMap.Entry)majorAxisMap.last() : (Int2ObjectMap.Entry)majorAxisMap.first();
            if (majorEntry == null) {
                return null;
            }
            VoxelPlane plane = (VoxelPlane)majorEntry.getValue();
            if ((missing += plane.getMissing()) > tolerance) {
                return null;
            }
            int majorKey = majorEntry.getIntKey();
            builder.set(side, majorKey);
            if (!(builder.trySet(VoxelCuboid.CuboidSide.get(VoxelCuboid.CuboidSide.Face.NEGATIVE, horizontal), plane.getMinCol()) && builder.trySet(VoxelCuboid.CuboidSide.get(VoxelCuboid.CuboidSide.Face.POSITIVE, horizontal), plane.getMaxCol()) && builder.trySet(VoxelCuboid.CuboidSide.get(VoxelCuboid.CuboidSide.Face.NEGATIVE, vertical), plane.getMinRow()) && builder.trySet(VoxelCuboid.CuboidSide.get(VoxelCuboid.CuboidSide.Face.POSITIVE, vertical), plane.getMaxRow()))) {
                return null;
            }
            Int2ObjectSortedMap<VoxelPlane> minorAxisMap = structure.getMinorAxisMap(axis);
            if (minorAxisMap.isEmpty() || !(side.getFace().isPositive() ? StructureHelper.hasOutOfBoundsPositiveMinor(minorAxisMap, majorKey) : StructureHelper.hasOutOfBoundsNegativeMinor(minorAxisMap, majorKey))) continue;
            return null;
        }
        VoxelCuboid ret = builder.build();
        if (!ret.greaterOrEqual(minBounds) || !maxBounds.greaterOrEqual(ret)) {
            return null;
        }
        return ret;
    }

    private static boolean hasOutOfBoundsPositiveMinor(Int2ObjectSortedMap<VoxelPlane> minorAxisMap, int majorKey) {
        Int2ObjectMap.Entry minorEntry;
        int minorKey;
        ObjectSortedSet entries = minorAxisMap.int2ObjectEntrySet();
        ObjectBidirectionalIterator iterator = entries.iterator((Object)((Int2ObjectMap.Entry)entries.last()));
        while (iterator.hasPrevious() && (minorKey = (minorEntry = (Int2ObjectMap.Entry)iterator.previous()).getIntKey()) > majorKey) {
            if (!((VoxelPlane)minorEntry.getValue()).hasFrame()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasOutOfBoundsNegativeMinor(Int2ObjectSortedMap<VoxelPlane> minorAxisMap, int majorKey) {
        Int2ObjectMap.Entry minorEntry;
        int minorKey;
        ObjectBidirectionalIterator objectBidirectionalIterator = minorAxisMap.int2ObjectEntrySet().iterator();
        while (objectBidirectionalIterator.hasNext() && (minorKey = (minorEntry = (Int2ObjectMap.Entry)objectBidirectionalIterator.next()).getIntKey()) < majorKey) {
            if (!((VoxelPlane)minorEntry.getValue()).hasFrame()) continue;
            return true;
        }
        return false;
    }
}

