/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.Optional;
import mekanism.api.radiation.IRadiationSource;
import mekanism.common.config.MekanismConfig;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;

public class RadiationSource
implements IRadiationSource {
    private final GlobalPos pos;
    private double magnitude;

    public RadiationSource(GlobalPos pos, double magnitude) {
        this.pos = pos;
        this.magnitude = magnitude;
    }

    @Override
    @NotNull
    public GlobalPos getPos() {
        return this.pos;
    }

    @Override
    public double getMagnitude() {
        return this.magnitude;
    }

    @Override
    public void radiate(double magnitude) {
        this.magnitude += magnitude;
    }

    @Override
    public boolean decay() {
        this.magnitude *= MekanismConfig.general.radiationSourceDecayRate.get();
        return this.magnitude < 1.0E-5;
    }

    public static Optional<RadiationSource> load(CompoundTag tag) {
        Optional result = GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).result();
        if (result.isPresent()) {
            return Optional.of(new RadiationSource((GlobalPos)result.get(), tag.getDouble("radiation")));
        }
        return Optional.empty();
    }

    public CompoundTag write() {
        CompoundTag tag = (CompoundTag)GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.pos).result().orElseGet(CompoundTag::new);
        tag.putDouble("radiation", this.magnitude);
        return tag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RadiationSource other = (RadiationSource)o;
        return this.magnitude == other.magnitude && this.pos.equals((Object)other.pos);
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.magnitude);
    }
}

