/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.security;

import mekanism.api.security.SecurityMode;
import mekanism.common.lib.security.SecurityFrequency;
import net.minecraft.network.FriendlyByteBuf;

public record SecurityData(SecurityMode mode, boolean override) {
    public static final SecurityData DUMMY = new SecurityData(SecurityMode.PUBLIC, false);

    public SecurityData(SecurityFrequency frequency) {
        this(frequency.getSecurity(), frequency.isOverridden());
    }

    public static SecurityData read(FriendlyByteBuf dataStream) {
        return new SecurityData((SecurityMode)dataStream.readEnum(SecurityMode.class), dataStream.readBoolean());
    }

    public void write(FriendlyByteBuf dataStream) {
        dataStream.writeEnum((Enum)this.mode);
        dataStream.writeBoolean(this.override);
    }
}

