/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.security;

import java.util.List;
import java.util.UUID;
import mekanism.api.security.SecurityMode;
import mekanism.common.lib.collection.HashList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.PacketUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public class SecurityFrequency
extends Frequency {
    public static final String SECURITY = "Security";
    private boolean override = false;
    private final HashList<UUID> trusted = new HashList();
    private HashList<String> trustedCache = new HashList();
    private int trustedCacheHash;

    public SecurityFrequency(@Nullable UUID uuid) {
        super(FrequencyType.SECURITY, SECURITY, uuid);
    }

    public SecurityFrequency() {
        super(FrequencyType.SECURITY, SECURITY, null);
    }

    @Override
    public UUID getKey() {
        return this.getOwner();
    }

    @Override
    public void write(CompoundTag nbtTags) {
        super.write(nbtTags);
        nbtTags.putBoolean("override", this.override);
        if (!this.trusted.isEmpty()) {
            ListTag trustedList = new ListTag();
            for (UUID uuid : this.trusted) {
                trustedList.add((Object)NbtUtils.createUUID((UUID)uuid));
            }
            nbtTags.put("trusted", (Tag)trustedList);
        }
    }

    @Override
    protected void read(CompoundTag nbtTags) {
        super.read(nbtTags);
        NBTUtils.setBooleanIfPresent(nbtTags, "override", value -> {
            this.override = value;
        });
        if (nbtTags.contains("trusted", 9)) {
            ListTag trustedList = nbtTags.getList("trusted", 11);
            for (Tag trusted : trustedList) {
                UUID uuid = NbtUtils.loadUUID((Tag)trusted);
                this.addTrustedRaw(uuid, MekanismUtils.getLastKnownUsername(uuid));
            }
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.override);
        buffer.writeCollection(this.trustedCache, (buf, name) -> buf.writeUtf(name, PacketUtils.LAST_USERNAME_LENGTH));
    }

    @Override
    protected void read(FriendlyByteBuf dataStream) {
        super.read(dataStream);
        this.override = dataStream.readBoolean();
        this.trustedCache = (HashList)dataStream.readCollection(HashList::new, buf -> buf.readUtf(PacketUtils.LAST_USERNAME_LENGTH));
    }

    @Override
    public int getSyncHash() {
        int code = super.getSyncHash();
        code = 31 * code + (this.override ? 1 : 0);
        code = 31 * code + this.getSecurity().ordinal();
        code = 31 * code + this.trustedCacheHash;
        return code;
    }

    public void setOverridden(boolean override) {
        if (this.override != override) {
            this.override = override;
            this.dirty = true;
        }
    }

    @Override
    public Frequency.FrequencyIdentity getIdentity() {
        return new Frequency.FrequencyIdentity(this.getKey(), SecurityMode.PUBLIC, this.getOwner());
    }

    public boolean isOverridden() {
        return this.override;
    }

    public boolean isTrusted(UUID subject) {
        return this.trusted.contains(subject);
    }

    public List<String> getTrustedUsernameCache() {
        return this.trustedCache.elements();
    }

    public void addTrusted(UUID uuid, String name) {
        if (!this.trusted.contains(uuid)) {
            this.addTrustedRaw(uuid, name);
            this.dirty = true;
        }
    }

    private void addTrustedRaw(UUID uuid, String name) {
        this.trusted.add(uuid);
        this.trustedCache.add(name);
        this.trustedCacheHash = this.trustedCache.hashCode();
    }

    @Nullable
    public UUID removeTrusted(int index) {
        UUID uuid = null;
        if (index >= 0 && index < this.trusted.size()) {
            uuid = this.trusted.remove(index);
            this.dirty = true;
        }
        if (index >= 0 && index < this.trustedCache.size()) {
            this.trustedCache.remove(index);
            this.trustedCacheHash = this.trustedCache.hashCode();
        }
        return uuid;
    }
}

