/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.transmitter.acceptor;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.integration.energy.IEnergyCompat;
import mekanism.common.lib.transmitter.acceptor.AbstractAcceptorCache;
import mekanism.common.lib.transmitter.acceptor.AcceptorInfo;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class EnergyAcceptorCache
extends AbstractAcceptorCache<IStrictEnergyHandler, EnergyAcceptorInfo> {
    public EnergyAcceptorCache(TileEntityTransmitter transmitterTile) {
        super(transmitterTile);
    }

    @Override
    protected EnergyAcceptorInfo initializeCache(ServerLevel level, BlockPos pos, Direction opposite, AbstractAcceptorCache.RefreshListener refreshListener) {
        EnergyAcceptorInfo acceptorInfo = new EnergyAcceptorInfo();
        for (IEnergyCompat energyCompat : EnergyCompatUtils.getCompats()) {
            if (!energyCompat.capabilityExists()) continue;
            acceptorInfo.addCapability(energyCompat, level, pos, opposite, refreshListener);
        }
        return acceptorInfo;
    }

    public static class EnergyAcceptorInfo
    implements AcceptorInfo<IStrictEnergyHandler> {
        private final List<CacheInfo> capabilities = new ArrayList<CacheInfo>();

        EnergyAcceptorInfo() {
        }

        void addCapability(IEnergyCompat energyCompat, ServerLevel level, BlockPos pos, Direction opposite, AbstractAcceptorCache.RefreshListener refreshListener) {
            this.capabilities.add(new CacheInfo(energyCompat, energyCompat.getCapability().createCache(level, pos, opposite, refreshListener, refreshListener)));
        }

        @Override
        @Nullable
        public IStrictEnergyHandler acceptor() {
            for (CacheInfo cacheInfo : this.capabilities) {
                Object capability;
                IEnergyCompat energyCompat = cacheInfo.energyCompat();
                if (!energyCompat.isUsable() || (capability = cacheInfo.cache().getCapability()) == null) continue;
                return energyCompat.wrapAsStrictEnergyHandler(capability);
            }
            return null;
        }

        private record CacheInfo(IEnergyCompat energyCompat, BlockCapabilityCache<?, @Nullable Direction> cache) {
        }
    }
}

