/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.lib.math.Range3D;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class PacketUtils {
    public static final int LAST_USERNAME_LENGTH = Math.max(16, 38);
    private static final PacketDistributor<DynamicBufferedNetwork<?, ?, ?, ?>> TRACKING_NETWORK = new PacketDistributor(PacketUtils::trackingNetwork, PacketFlow.CLIENTBOUND);

    private PacketUtils() {
    }

    public static void log(String logFormat, Object ... params) {
        if (MekanismConfig.general.logPackets.get()) {
            Mekanism.logger.info(logFormat, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <OBJ> OBJ read(byte[] rawData, FriendlyByteBuf.Reader<OBJ> deserializer) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])rawData));
        try {
            Object object = deserializer.apply((Object)buffer);
            return (OBJ)object;
        }
        finally {
            buffer.release();
        }
    }

    public static <KEY, V1, V2> void writeMultipleMaps(FriendlyByteBuf buffer, Map<KEY, V1> map1, Map<KEY, V2> map2, FriendlyByteBuf.Writer<KEY> keyWriter, FriendlyByteBuf.Writer<V1> v1Writer, FriendlyByteBuf.Writer<V2> v2Writer) {
        if (map1.size() != map2.size()) {
            throw new IllegalArgumentException("Expected map1 and map2 to have the same size");
        }
        buffer.writeVarInt(map1.size());
        for (Map.Entry<KEY, V1> entry : map1.entrySet()) {
            KEY key = entry.getKey();
            keyWriter.accept((Object)buffer, key);
            v1Writer.accept((Object)buffer, entry.getValue());
            V2 v2 = map2.get(key);
            if (v2 == null) {
                throw new IllegalArgumentException("Expected maps to have the same keys but map2 was missing key " + key);
            }
            v2Writer.accept((Object)buffer, v2);
        }
    }

    public static <KEY, V1, V2> Pair<Map<KEY, V1>, Map<KEY, V2>> readMultipleMaps(FriendlyByteBuf buffer, FriendlyByteBuf.Reader<KEY> keyReader, FriendlyByteBuf.Reader<V1> v1Reader, FriendlyByteBuf.Reader<V2> v2Reader) {
        return PacketUtils.readMultipleMaps(buffer, Maps::newHashMapWithExpectedSize, Maps::newHashMapWithExpectedSize, keyReader, v1Reader, v2Reader);
    }

    public static <KEY, V1, V2, M1 extends Map<KEY, V1>, M2 extends Map<KEY, V2>> Pair<M1, M2> readMultipleMaps(FriendlyByteBuf buffer, IntFunction<M1> map1Factory, IntFunction<M2> map2Factory, FriendlyByteBuf.Reader<KEY> keyReader, FriendlyByteBuf.Reader<V1> v1Reader, FriendlyByteBuf.Reader<V2> v2Reader) {
        int size = buffer.readVarInt();
        Map map1 = (Map)map1Factory.apply(size);
        Map map2 = (Map)map2Factory.apply(size);
        for (int element = 0; element < size; ++element) {
            Object key = keyReader.apply((Object)buffer);
            map1.put(key, v1Reader.apply((Object)buffer));
            map2.put(key, v2Reader.apply((Object)buffer));
        }
        return Pair.of((Object)map1, (Object)map2);
    }

    public static Optional<ServerPlayer> asServerPlayer(IPayloadContext context) {
        return context.player().filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast);
    }

    @Nullable
    public static TileComponentEjector ejector(IPayloadContext context, BlockPos pos) {
        ISideConfiguration sideConfig = PacketUtils.blockEntity(context, pos, ISideConfiguration.class);
        return sideConfig == null ? null : sideConfig.getEjector();
    }

    @Nullable
    public static TileComponentConfig config(IPayloadContext context, BlockPos pos) {
        ISideConfiguration sideConfig = PacketUtils.blockEntity(context, pos, ISideConfiguration.class);
        return sideConfig == null ? null : sideConfig.getConfig();
    }

    @Nullable
    public static FilterManager<?> filterManager(IPayloadContext context, BlockPos pos) {
        ITileFilterHolder filterHolder = PacketUtils.blockEntity(context, pos, ITileFilterHolder.class);
        return filterHolder == null ? null : filterHolder.getFilterManager();
    }

    @Nullable
    public static <CLASS> CLASS blockEntity(IPayloadContext context, BlockPos pos, Class<CLASS> clazz) {
        BlockEntity be = PacketUtils.blockEntity(context, pos);
        if (clazz.isInstance(be)) {
            return clazz.cast(be);
        }
        return null;
    }

    @Nullable
    public static BlockEntity blockEntity(IPayloadContext context, BlockPos pos) {
        return WorldUtils.getTileEntity(context.level().orElse(null), pos);
    }

    @Nullable
    public static <CLASS extends AbstractContainerMenu> CLASS container(IPayloadContext context, Class<CLASS> clazz) {
        Player player = context.player().orElse(null);
        if (player != null && clazz.isInstance(player.containerMenu)) {
            return (CLASS)((AbstractContainerMenu)clazz.cast(player.containerMenu));
        }
        return null;
    }

    public static <MSG extends CustomPacketPayload> void sendTo(MSG message, ServerPlayer player) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{message});
    }

    public static <MSG extends CustomPacketPayload> void sendToAll(MSG message) {
        PacketDistributor.ALL.noArg().send(new CustomPacketPayload[]{message});
    }

    public static <MSG extends CustomPacketPayload> void sendToAllIfLoaded(MSG message) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            PacketUtils.sendToAll(message);
        }
    }

    public static <MSG extends CustomPacketPayload> void sendToDimension(MSG message, ResourceKey<Level> dimension) {
        PacketDistributor.DIMENSION.with(dimension).send(new CustomPacketPayload[]{message});
    }

    public static <MSG extends CustomPacketPayload> boolean sendToServer(MSG message) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{message});
        return true;
    }

    public static <MSG extends CustomPacketPayload> void sendToAllTracking(MSG message, Entity entity) {
        PacketDistributor.TRACKING_ENTITY.with((Object)entity).send(new CustomPacketPayload[]{message});
    }

    public static <MSG extends CustomPacketPayload> void sendToAllTrackingAndSelf(MSG message, Entity entity) {
        PacketDistributor.TRACKING_ENTITY_AND_SELF.with((Object)entity).send(new CustomPacketPayload[]{message});
    }

    public static <MSG extends CustomPacketPayload> void sendToAllTracking(MSG message, BlockEntity tile) {
        PacketUtils.sendToAllTracking(message, tile.getLevel(), tile.getBlockPos());
    }

    public static <MSG extends CustomPacketPayload> void sendToAllTracking(MSG message, Level world, BlockPos pos) {
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            for (ServerPlayer p : level.getChunkSource().chunkMap.getPlayers(new ChunkPos(pos), false)) {
                PacketUtils.sendTo(message, p);
            }
        } else {
            PacketDistributor.TRACKING_CHUNK.with((Object)world.getChunk(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()))).send(new CustomPacketPayload[]{message});
        }
    }

    public static void sendToAllTracking(DynamicBufferedNetwork<?, ?, ?, ?> network, CustomPacketPayload ... packets) {
        TRACKING_NETWORK.with(network).send(packets);
    }

    private static boolean isChunkTracked(ServerPlayer player, int chunkX, int chunkZ) {
        return player.getChunkTrackingView().contains(chunkX, chunkZ) && !player.connection.chunkSender.isPending(ChunkPos.asLong((int)chunkX, (int)chunkZ));
    }

    private static <NETWORK extends DynamicBufferedNetwork<?, ?, ?, ?>> Consumer<Packet<?>> trackingNetwork(PacketDistributor<NETWORK> packetDistributor, NETWORK network) {
        return p -> {
            Range3D range = network.getPacketRange();
            PlayerList playerList = ServerLifecycleHooks.getCurrentServer().getPlayerList();
            int radius = playerList.getViewDistance() * 16;
            for (ServerPlayer player : playerList.getPlayers()) {
                if (range.dimension() != player.level().dimension()) continue;
                BlockPos playerPosition = player.blockPosition();
                int playerX = playerPosition.getX();
                int playerZ = playerPosition.getZ();
                if (!((double)(playerX + radius) + 1.99999 > (double)range.xMin()) || !((double)range.xMax() + 0.99999 > (double)(playerX - radius)) || !((double)(playerZ + radius) + 1.99999 > (double)range.zMin()) || !((double)range.zMax() + 0.99999 > (double)(playerZ - radius))) continue;
                player.connection.send(p);
            }
        };
    }
}

