/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client;

import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketHitBlockEffect(BlockHitResult result) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("hit_block");

    public PacketHitBlockEffect(FriendlyByteBuf buffer) {
        this(buffer.readBlockHitResult());
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        if (context.level().isPresent()) {
            Minecraft.getInstance().particleEngine.addBlockHitEffects(this.result.getBlockPos(), this.result);
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeBlockHitResult(this.result);
    }
}

