/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client;

import java.util.function.BooleanSupplier;
import mekanism.client.render.RenderTickHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.effect.BoltEffect;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketLightningRender(LightningPreset preset, int renderer, Vec3 start, Vec3 end, int segments) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("render_bolt");

    public PacketLightningRender(FriendlyByteBuf buffer) {
        this((LightningPreset)buffer.readEnum(LightningPreset.class), buffer.readVarInt(), buffer.readVec3(), buffer.readVec3(), buffer.readVarInt());
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        if (this.preset.shouldAdd.getAsBoolean()) {
            RenderTickHandler.renderBolt(this.renderer, this.preset.boltCreator.create(this.start, this.end, this.segments));
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.preset);
        buffer.writeVarInt(this.renderer);
        buffer.writeVec3(this.start);
        buffer.writeVec3(this.end);
        buffer.writeVarInt(this.segments);
    }

    public static enum LightningPreset {
        MAGNETIC_ATTRACTION(MekanismConfig.client.renderMagneticAttractionParticles, (start, end, segments) -> new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, start, end, segments).size(0.04f).lifespan(8).spawn(BoltEffect.SpawnFunction.noise(8.0f, 4.0f))),
        TOOL_AOE(MekanismConfig.client.renderToolAOEParticles, (start, end, segments) -> new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, start, end, segments).size(0.015f).lifespan(12).spawn(BoltEffect.SpawnFunction.NO_DELAY));

        private final BooleanSupplier shouldAdd;
        private final BoltCreator boltCreator;

        private LightningPreset(BooleanSupplier shouldAdd, BoltCreator boltCreator) {
            this.shouldAdd = shouldAdd;
            this.boltCreator = boltCreator;
        }
    }

    @FunctionalInterface
    public static interface BoltCreator {
        public BoltEffect create(Vec3 var1, Vec3 var2, int var3);
    }
}

