/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client;

import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketPortalFX(BlockPos pos, Direction direction) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("portal_fx");

    public PacketPortalFX(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), (Direction)buffer.readEnum(Direction.class));
    }

    public PacketPortalFX(BlockPos pos) {
        this(pos, Direction.UP);
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        Level world = context.level().orElse(null);
        if (world != null) {
            BlockPos secondPos = this.pos.relative(this.direction);
            for (int i = 0; i < 50; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)((float)this.pos.getX() + world.random.nextFloat()), (double)((float)this.pos.getY() + world.random.nextFloat()), (double)((float)this.pos.getZ() + world.random.nextFloat()), 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)((float)secondPos.getX() + world.random.nextFloat()), (double)((float)secondPos.getY() + world.random.nextFloat()), (double)((float)secondPos.getZ() + world.random.nextFloat()), 0.0, 0.0, 0.0);
            }
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeEnum((Enum)this.direction);
    }
}

