/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client.container;

import java.util.List;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.container.property.PropertyData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketUpdateContainer(short windowId, List<PropertyData> data) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("update_container");

    public PacketUpdateContainer(FriendlyByteBuf buffer) {
        this(buffer.readUnsignedByte(), buffer.readList(PropertyData::fromBuffer));
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        MekanismContainer container = PacketUtils.container((IPayloadContext)context, MekanismContainer.class);
        if (container != null && container.containerId == this.windowId) {
            for (PropertyData datum : this.data) {
                datum.handleWindowProperty(container);
            }
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeByte((int)this.windowId);
        buffer.writeObjectCollection(this.data, PropertyData::writeToPacket);
    }
}

