/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client.transmitter;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.Map;
import mekanism.common.Mekanism;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.FriendlyByteBufUtil;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketTransporterBatch(BlockPos pos, IntSet deletes, byte[] rawUpdates) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("transporter_batch");

    public PacketTransporterBatch(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), (IntSet)buffer.readCollection(IntOpenHashSet::new, FriendlyByteBuf::readVarInt), buffer.readByteArray());
    }

    public PacketTransporterBatch(BlockPos pos, IntSet deletes, Int2ObjectMap<TransporterStack> updates) {
        this(pos, deletes, FriendlyByteBufUtil.writeCustomData(buffer -> buffer.writeMap((Map)updates, FriendlyByteBuf::writeVarInt, (buf, stack) -> stack.write((FriendlyByteBuf)buf, pos))));
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        TileEntityLogisticalTransporterBase tile = PacketUtils.blockEntity((IPayloadContext)context, this.pos, TileEntityLogisticalTransporterBase.class);
        if (tile != null) {
            LogisticalTransporterBase transporter = tile.getTransmitter();
            Int2ObjectMap updates = (Int2ObjectMap)PacketUtils.read(this.rawUpdates, buffer -> (Int2ObjectOpenHashMap)buffer.readMap(Int2ObjectOpenHashMap::new, FriendlyByteBuf::readVarInt, TransporterStack::readFromPacket));
            for (Int2ObjectMap.Entry entry : updates.int2ObjectEntrySet()) {
                transporter.addStack(entry.getIntKey(), (TransporterStack)entry.getValue());
            }
            ObjectIterator objectIterator = this.deletes.iterator();
            while (objectIterator.hasNext()) {
                int toDelete = (Integer)objectIterator.next();
                transporter.deleteStack(toDelete);
            }
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeCollection((Collection)this.deletes, FriendlyByteBuf::writeVarInt);
        buffer.writeByteArray(this.rawUpdates);
    }
}

