/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client.transmitter;

import mekanism.common.Mekanism;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.FriendlyByteBufUtil;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketTransporterSync(BlockPos pos, int stackId, byte[] rawStack) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("transporter_sync");

    public PacketTransporterSync(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), buffer.readVarInt(), buffer.readByteArray());
    }

    public PacketTransporterSync(BlockPos pos, int stackId, TransporterStack stack) {
        this(pos, stackId, FriendlyByteBufUtil.writeCustomData(buffer -> stack.write((FriendlyByteBuf)buffer, pos)));
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        TileEntityLogisticalTransporterBase tile = PacketUtils.blockEntity((IPayloadContext)context, this.pos, TileEntityLogisticalTransporterBase.class);
        if (tile != null) {
            LogisticalTransporterBase transporter = tile.getTransmitter();
            TransporterStack stack = (TransporterStack)PacketUtils.read(this.rawStack, TransporterStack::readFromPacket);
            transporter.addStack(this.stackId, stack);
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeVarInt(this.stackId);
        buffer.writeByteArray(this.rawStack);
    }
}

