/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.util.text.InputValidator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketAddTrusted(BlockPos pos, String name) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("add_trusted");

    public PacketAddTrusted(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), buffer.readUtf(16));
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        TileEntitySecurityDesk tile;
        if (!this.name.isEmpty() && InputValidator.test(this.name, InputValidator.USERNAME) && (tile = PacketUtils.blockEntity((IPayloadContext)context, this.pos, TileEntitySecurityDesk.class)) != null) {
            tile.addTrusted(this.name);
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeUtf(this.name, 16);
    }
}

