/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.tier.BaseTier;
import mekanism.common.Mekanism;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.advancements.triggers.UseGaugeDropperTrigger;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public class PacketDropperUse
implements IMekanismPacket<PlayPayloadContext> {
    public static final ResourceLocation ID = Mekanism.rl("use_dropper");
    private final BlockPos pos;
    private final DropperAction action;
    private final TankType tankType;
    private final int tankId;

    public PacketDropperUse(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), (DropperAction)buffer.readEnum(DropperAction.class), (TankType)buffer.readEnum(TankType.class), buffer.readVarInt());
    }

    public PacketDropperUse(BlockPos pos, DropperAction action, TankType tankType, int tankId) {
        this.pos = pos;
        this.action = action;
        this.tankType = tankType;
        this.tankId = tankId;
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        if (this.tankId < 0) {
            return;
        }
        Player optionalPlayer = context.player().orElse(null);
        if (optionalPlayer instanceof ServerPlayer) {
            TileEntityMekanism tile;
            ServerPlayer player = (ServerPlayer)optionalPlayer;
            ItemStack stack = player.containerMenu.getCarried();
            if (!stack.isEmpty() && stack.getItem() instanceof ItemGaugeDropper && (tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.level(), this.pos)) != null) {
                if (tile instanceof TileEntityMultiblock) {
                    TileEntityMultiblock multiblock = (TileEntityMultiblock)tile;
                    MultiblockData structure = multiblock.getMultiblock();
                    if (structure.isFormed()) {
                        this.handleTankType(structure, player, stack, GlobalPos.of((ResourceKey)player.level().dimension(), (BlockPos)structure.getBounds().getCenter()));
                    }
                } else {
                    if (this.action == DropperAction.DUMP_TANK && !player.isCreative() && Attribute.getBaseTier(tile.getBlockType()) == BaseTier.CREATIVE) {
                        return;
                    }
                    this.handleTankType(tile, player, stack, tile.getTileGlobalPos());
                }
            }
        }
    }

    private <HANDLER extends IMekanismFluidHandler & IGasTracker & IPigmentTracker> void handleTankType(HANDLER handler, ServerPlayer player, ItemStack stack, GlobalPos pos) {
        if (this.tankType == TankType.FLUID_TANK) {
            IExtendedFluidTank fluidTank = handler.getFluidTank(this.tankId, null);
            if (fluidTank != null) {
                this.handleFluidTank(player, stack, fluidTank);
            }
        } else if (this.tankType == TankType.GAS_TANK) {
            this.handleChemicalTanks(player, stack, ((IGasTracker)handler).getGasTanks(null), pos);
        } else if (this.tankType == TankType.INFUSION_TANK) {
            this.handleChemicalTanks(player, stack, ((IInfusionTracker)handler).getInfusionTanks(null), pos);
        } else if (this.tankType == TankType.PIGMENT_TANK) {
            this.handleChemicalTanks(player, stack, ((IPigmentTracker)handler).getPigmentTanks(null), pos);
        } else if (this.tankType == TankType.SLURRY_TANK) {
            this.handleChemicalTanks(player, stack, ((ISlurryTracker)handler).getSlurryTanks(null), pos);
        }
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> void handleChemicalTanks(ServerPlayer player, ItemStack stack, List<TANK> tanks, GlobalPos pos) {
        if (this.tankId < tanks.size()) {
            this.handleChemicalTank(player, stack, (IChemicalTank)tanks.get(this.tankId), pos);
        }
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void handleChemicalTank(ServerPlayer player, ItemStack stack, IChemicalTank<CHEMICAL, STACK> tank, GlobalPos pos) {
        if (this.action == DropperAction.DUMP_TANK) {
            if (!tank.isEmpty()) {
                if (tank instanceof IGasTank) {
                    IGasTank gasTank = (IGasTank)tank;
                    IRadiationManager.INSTANCE.dumpRadiation(pos, (GasStack)gasTank.getStack());
                }
                tank.setEmpty();
                ((UseGaugeDropperTrigger)((Object)MekanismCriteriaTriggers.USE_GAUGE_DROPPER.value())).trigger(player, UseGaugeDropperTrigger.UseDropperAction.DUMP);
            }
        } else {
            IMekanismChemicalHandler chemicalHandler;
            Object itemTank;
            IChemicalHandler handler = (IChemicalHandler)ChemicalUtil.getCapabilityForChemical(tank).getCapability(stack);
            if (handler instanceof IMekanismChemicalHandler && (itemTank = (chemicalHandler = (IMekanismChemicalHandler)handler).getChemicalTank(0, null)) != null) {
                if (this.action == DropperAction.FILL_DROPPER) {
                    PacketDropperUse.transferBetweenTanks(tank, itemTank, (Player)player);
                    ((UseGaugeDropperTrigger)((Object)MekanismCriteriaTriggers.USE_GAUGE_DROPPER.value())).trigger(player, UseGaugeDropperTrigger.UseDropperAction.FILL);
                } else if (this.action == DropperAction.DRAIN_DROPPER) {
                    PacketDropperUse.transferBetweenTanks(itemTank, tank, (Player)player);
                    ((UseGaugeDropperTrigger)((Object)MekanismCriteriaTriggers.USE_GAUGE_DROPPER.value())).trigger(player, UseGaugeDropperTrigger.UseDropperAction.DRAIN);
                }
            }
        }
    }

    private void handleFluidTank(ServerPlayer player, ItemStack stack, IExtendedFluidTank fluidTank) {
        IMekanismFluidHandler fluidHandler;
        IExtendedFluidTank itemFluidTank;
        if (this.action == DropperAction.DUMP_TANK) {
            fluidTank.setEmpty();
            ((UseGaugeDropperTrigger)((Object)MekanismCriteriaTriggers.USE_GAUGE_DROPPER.value())).trigger(player, UseGaugeDropperTrigger.UseDropperAction.DUMP);
            return;
        }
        IFluidHandlerItem fluidHandlerItem = Capabilities.FLUID.getCapability(stack);
        if (fluidHandlerItem instanceof IMekanismFluidHandler && (itemFluidTank = (fluidHandler = (IMekanismFluidHandler)fluidHandlerItem).getFluidTank(0, null)) != null) {
            if (this.action == DropperAction.FILL_DROPPER) {
                PacketDropperUse.transferBetweenTanks(fluidTank, itemFluidTank, (Player)player);
                ((UseGaugeDropperTrigger)((Object)MekanismCriteriaTriggers.USE_GAUGE_DROPPER.value())).trigger(player, UseGaugeDropperTrigger.UseDropperAction.FILL);
            } else if (this.action == DropperAction.DRAIN_DROPPER) {
                PacketDropperUse.transferBetweenTanks(itemFluidTank, fluidTank, (Player)player);
                ((UseGaugeDropperTrigger)((Object)MekanismCriteriaTriggers.USE_GAUGE_DROPPER.value())).trigger(player, UseGaugeDropperTrigger.UseDropperAction.DRAIN);
            }
        }
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void transferBetweenTanks(IChemicalTank<CHEMICAL, STACK> drainTank, IChemicalTank<CHEMICAL, STACK> fillTank, Player player) {
        STACK extractedChemical;
        long amount;
        STACK chemicalInDrainTank;
        STACK simulatedRemainder;
        long remainder;
        if (!drainTank.isEmpty() && fillTank.getNeeded() > 0L && (remainder = ((ChemicalStack)(simulatedRemainder = fillTank.insert(chemicalInDrainTank = drainTank.getStack(), Action.SIMULATE, AutomationType.MANUAL))).getAmount()) < (amount = ((ChemicalStack)chemicalInDrainTank).getAmount()) && !((ChemicalStack)(extractedChemical = drainTank.extract(amount - remainder, Action.EXECUTE, AutomationType.MANUAL))).isEmpty()) {
            MekanismUtils.logMismatchedStackSize(((ChemicalStack)fillTank.insert(extractedChemical, Action.EXECUTE, AutomationType.MANUAL)).getAmount(), 0L);
            player.containerMenu.synchronizeCarriedToRemote();
        }
    }

    private static void transferBetweenTanks(IExtendedFluidTank drainTank, IExtendedFluidTank fillTank, Player player) {
        FluidStack extractedFluid;
        int amount;
        FluidStack fluidInDrainTank;
        FluidStack simulatedRemainder;
        int remainder;
        if (!drainTank.isEmpty() && fillTank.getNeeded() > 0 && (remainder = (simulatedRemainder = fillTank.insert(fluidInDrainTank = drainTank.getFluid(), Action.SIMULATE, AutomationType.MANUAL)).getAmount()) < (amount = fluidInDrainTank.getAmount()) && !(extractedFluid = drainTank.extract(amount - remainder, Action.EXECUTE, AutomationType.MANUAL)).isEmpty()) {
            MekanismUtils.logMismatchedStackSize(fillTank.insert(extractedFluid, Action.EXECUTE, AutomationType.MANUAL).getAmount(), 0L);
            player.containerMenu.synchronizeCarriedToRemote();
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeEnum((Enum)this.action);
        buffer.writeEnum((Enum)this.tankType);
        buffer.writeVarInt(this.tankId);
    }

    public static enum DropperAction {
        FILL_DROPPER,
        DRAIN_DROPPER,
        DUMP_TANK;

    }

    public static enum TankType {
        GAS_TANK,
        FLUID_TANK,
        INFUSION_TANK,
        PIGMENT_TANK,
        SLURRY_TANK;

    }
}

