/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.player_data.PacketPlayerData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public class PacketGearStateUpdate
implements IMekanismPacket<PlayPayloadContext> {
    public static final ResourceLocation ID = Mekanism.rl("update_gear");
    private final GearType gearType;
    private final boolean state;
    private final UUID uuid;

    public PacketGearStateUpdate(FriendlyByteBuf buffer) {
        this((GearType)buffer.readEnum(GearType.class), buffer.readUUID(), buffer.readBoolean());
    }

    public PacketGearStateUpdate(GearType gearType, UUID uuid, boolean state) {
        this.gearType = gearType;
        this.uuid = uuid;
        this.state = state;
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        switch (this.gearType) {
            case JETPACK: {
                Mekanism.playerState.setJetpackState(this.uuid, this.state, false);
                break;
            }
            case SCUBA_MASK: {
                Mekanism.playerState.setScubaMaskState(this.uuid, this.state, false);
                break;
            }
            case GRAVITATIONAL_MODULATOR: {
                Mekanism.playerState.setGravitationalModulationState(this.uuid, this.state, false);
            }
        }
        Player player = context.player().orElse(null);
        if (player != null) {
            PacketUtils.sendToAllTracking(new PacketPlayerData(this.uuid), (Entity)player);
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.gearType);
        buffer.writeUUID(this.uuid);
        buffer.writeBoolean(this.state);
    }

    public static enum GearType {
        JETPACK,
        SCUBA_MASK,
        GRAVITATIONAL_MODULATOR;

    }
}

