/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.api.Upgrade;
import mekanism.api.functions.TriConsumer;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.api.security.IEntitySecurityUtils;
import mekanism.api.security.SecurityMode;
import mekanism.common.Mekanism;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.content.filter.SortableFilterManager;
import mekanism.common.entity.EntityRobit;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.entity.robit.MainRobitContainer;
import mekanism.common.lib.inventory.IAdvancedTransportEjector;
import mekanism.common.lib.security.SecurityUtils;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.tile.interfaces.IHasGasMode;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.tile.machine.TileEntityDimensionalStabilizer;
import mekanism.common.tile.machine.TileEntityFormulaicAssemblicator;
import mekanism.common.tile.qio.TileEntityQIODashboard;
import mekanism.common.tile.qio.TileEntityQIOExporter;
import mekanism.common.tile.qio.TileEntityQIOImporter;
import mekanism.common.tile.qio.TileEntityQIORedstoneAdapter;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public class PacketGuiInteract
implements IMekanismPacket<PlayPayloadContext> {
    public static final ResourceLocation ID = Mekanism.rl("gui_interact");
    private final Type interactionType;
    private GuiInteraction interaction;
    private GuiInteractionItem itemInteraction;
    private GuiInteractionEntity entityInteraction;
    private BlockPos tilePosition;
    private ItemStack extraItem;
    private int entityID;
    private int extra;

    public PacketGuiInteract(GuiInteractionEntity interaction, Entity entity) {
        this(interaction, entity, 0);
    }

    public PacketGuiInteract(GuiInteractionEntity interaction, Entity entity, int extra) {
        this(interaction, entity.getId(), extra);
    }

    public PacketGuiInteract(GuiInteractionEntity interaction, int entityID, int extra) {
        this.interactionType = Type.ENTITY;
        this.entityInteraction = interaction;
        this.entityID = entityID;
        this.extra = extra;
    }

    public PacketGuiInteract(GuiInteraction interaction, BlockEntity tile) {
        this(interaction, tile.getBlockPos());
    }

    public PacketGuiInteract(GuiInteraction interaction, BlockEntity tile, int extra) {
        this(interaction, tile.getBlockPos(), extra);
    }

    public PacketGuiInteract(GuiInteraction interaction, BlockPos tilePosition) {
        this(interaction, tilePosition, 0);
    }

    public PacketGuiInteract(GuiInteraction interaction, BlockPos tilePosition, int extra) {
        this.interactionType = Type.INT;
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public PacketGuiInteract(GuiInteractionItem interaction, BlockEntity tile, ItemStack stack) {
        this(interaction, tile.getBlockPos(), stack);
    }

    public PacketGuiInteract(GuiInteractionItem interaction, BlockPos tilePosition, ItemStack stack) {
        this.interactionType = Type.ITEM;
        this.itemInteraction = interaction;
        this.tilePosition = tilePosition;
        this.extraItem = stack;
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        Player player = context.player().orElse(null);
        if (player != null) {
            if (this.interactionType == Type.ENTITY) {
                Entity entity = player.level().getEntity(this.entityID);
                if (entity != null) {
                    this.entityInteraction.consume(entity, player, this.extra);
                }
            } else {
                TileEntityMekanism tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.level(), this.tilePosition);
                if (tile != null) {
                    if (this.interactionType == Type.INT) {
                        this.interaction.consume(tile, player, this.extra);
                    } else if (this.interactionType == Type.ITEM) {
                        this.itemInteraction.consume(tile, player, this.extraItem);
                    }
                }
            }
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.interactionType);
        switch (this.interactionType) {
            case ENTITY: {
                buffer.writeEnum((Enum)this.entityInteraction);
                buffer.writeVarInt(this.entityID);
                buffer.writeVarInt(this.extra);
                break;
            }
            case INT: {
                buffer.writeEnum((Enum)this.interaction);
                buffer.writeBlockPos(this.tilePosition);
                buffer.writeVarInt(this.extra);
                break;
            }
            case ITEM: {
                buffer.writeEnum((Enum)this.itemInteraction);
                buffer.writeBlockPos(this.tilePosition);
                buffer.writeItem(this.extraItem);
            }
        }
    }

    public static PacketGuiInteract decode(FriendlyByteBuf buffer) {
        return switch ((Type)buffer.readEnum(Type.class)) {
            default -> throw new IncompatibleClassChangeError();
            case Type.ENTITY -> new PacketGuiInteract((GuiInteractionEntity)buffer.readEnum(GuiInteractionEntity.class), buffer.readVarInt(), buffer.readVarInt());
            case Type.INT -> new PacketGuiInteract((GuiInteraction)buffer.readEnum(GuiInteraction.class), buffer.readBlockPos(), buffer.readVarInt());
            case Type.ITEM -> new PacketGuiInteract((GuiInteractionItem)buffer.readEnum(GuiInteractionItem.class), buffer.readBlockPos(), buffer.readItem());
        };
    }

    public static enum GuiInteractionEntity {
        NEXT_SECURITY_MODE((entity, player, extra) -> SecurityUtils.get().incrementSecurityMode((Player)player, IEntitySecurityUtils.INSTANCE.securityCapability((Entity)entity))),
        PREVIOUS_SECURITY_MODE((entity, player, extra) -> SecurityUtils.get().decrementSecurityMode((Player)player, IEntitySecurityUtils.INSTANCE.securityCapability((Entity)entity))),
        CONTAINER_STOP_TRACKING((entity, player, extra) -> {
            AbstractContainerMenu patt20204$temp = player.containerMenu;
            if (patt20204$temp instanceof MekanismContainer) {
                MekanismContainer container = (MekanismContainer)patt20204$temp;
                container.stopTracking(extra);
            }
        }),
        CONTAINER_TRACK_SKIN_SELECT((entity, player, extra) -> {
            AbstractContainerMenu patt20421$temp = player.containerMenu;
            if (patt20421$temp instanceof MainRobitContainer) {
                MainRobitContainer container = (MainRobitContainer)patt20421$temp;
                container.startTrackingServer(extra, container);
            }
        }),
        GO_HOME((entity, player, extra) -> {
            EntityRobit robit;
            if (entity instanceof EntityRobit && IEntitySecurityUtils.INSTANCE.canAccess((Player)player, robit = (EntityRobit)entity)) {
                robit.goHome();
            }
        }),
        FOLLOW((entity, player, extra) -> {
            EntityRobit robit;
            if (entity instanceof EntityRobit && IEntitySecurityUtils.INSTANCE.canAccess((Player)player, robit = (EntityRobit)entity)) {
                robit.setFollowing(!robit.getFollowing());
            }
        }),
        PICKUP_DROPS((entity, player, extra) -> {
            EntityRobit robit;
            if (entity instanceof EntityRobit && IEntitySecurityUtils.INSTANCE.canAccess((Player)player, robit = (EntityRobit)entity)) {
                robit.setDropPickup(!robit.getDropPickup());
            }
        });

        private final TriConsumer<Entity, Player, Integer> consumerForEntity;

        private GuiInteractionEntity(TriConsumer<Entity, Player, Integer> consumerForEntity) {
            this.consumerForEntity = consumerForEntity;
        }

        public void consume(Entity entity, Player player, int extra) {
            this.consumerForEntity.accept(entity, player, extra);
        }
    }

    private static enum Type {
        ENTITY,
        ITEM,
        INT;

    }

    public static enum GuiInteraction {
        CONTAINER_STOP_TRACKING((tile, player, extra) -> {
            AbstractContainerMenu patt7962$temp = player.containerMenu;
            if (patt7962$temp instanceof MekanismContainer) {
                MekanismContainer container = (MekanismContainer)patt7962$temp;
                container.stopTracking(extra);
            }
        }),
        CONTAINER_TRACK_EJECTOR((tile, player, extra) -> {
            AbstractContainerMenu patt8173$temp = player.containerMenu;
            if (patt8173$temp instanceof MekanismContainer) {
                MekanismContainer container = (MekanismContainer)patt8173$temp;
                if (tile instanceof ISideConfiguration) {
                    ISideConfiguration sideConfig = (ISideConfiguration)((Object)tile);
                    container.startTrackingServer(extra, sideConfig.getEjector());
                }
            }
        }),
        CONTAINER_TRACK_SIDE_CONFIG((tile, player, extra) -> {
            AbstractContainerMenu patt8469$temp = player.containerMenu;
            if (patt8469$temp instanceof MekanismContainer) {
                MekanismContainer container = (MekanismContainer)patt8469$temp;
                if (tile instanceof ISideConfiguration) {
                    ISideConfiguration sideConfig = (ISideConfiguration)((Object)tile);
                    container.startTrackingServer(extra, sideConfig.getConfig());
                }
            }
        }),
        CONTAINER_TRACK_UPGRADES((tile, player, extra) -> {
            AbstractContainerMenu patt8761$temp = player.containerMenu;
            if (patt8761$temp instanceof MekanismContainer) {
                MekanismContainer container = (MekanismContainer)patt8761$temp;
                container.startTrackingServer(extra, tile.getComponent());
            }
        }),
        QIO_REDSTONE_ADAPTER_COUNT((tile, player, extra) -> {
            if (tile instanceof TileEntityQIORedstoneAdapter) {
                TileEntityQIORedstoneAdapter redstoneAdapter = (TileEntityQIORedstoneAdapter)tile;
                redstoneAdapter.handleCountChange(extra.intValue());
            }
        }),
        QIO_REDSTONE_ADAPTER_FUZZY((tile, player, extra) -> {
            if (tile instanceof TileEntityQIORedstoneAdapter) {
                TileEntityQIORedstoneAdapter redstoneAdapter = (TileEntityQIORedstoneAdapter)tile;
                redstoneAdapter.toggleFuzzyMode();
            }
        }),
        QIO_TOGGLE_IMPORT_WITHOUT_FILTER((tile, player, extra) -> {
            if (tile instanceof TileEntityQIOImporter) {
                TileEntityQIOImporter importer = (TileEntityQIOImporter)tile;
                importer.toggleImportWithoutFilter();
            }
        }),
        QIO_TOGGLE_EXPORT_WITHOUT_FILTER((tile, player, extra) -> {
            if (tile instanceof TileEntityQIOExporter) {
                TileEntityQIOExporter exporter = (TileEntityQIOExporter)tile;
                exporter.toggleExportWithoutFilter();
            }
        }),
        AUTO_SORT_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityFactory) {
                TileEntityFactory factory = (TileEntityFactory)tile;
                factory.toggleSorting();
            }
        }),
        TARGET_DIRECTION_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityQIODashboard) {
                TileEntityQIODashboard dashboard = (TileEntityQIODashboard)tile;
                dashboard.toggleShiftClickDirection();
            }
        }),
        DUMP_BUTTON((tile, player, extra) -> {
            if (tile instanceof IHasDumpButton) {
                IHasDumpButton hasDumpButton = (IHasDumpButton)((Object)tile);
                hasDumpButton.dump();
            }
        }),
        GAS_MODE_BUTTON((tile, player, extra) -> {
            if (tile instanceof IHasGasMode) {
                IHasGasMode hasGasMode = (IHasGasMode)((Object)tile);
                hasGasMode.nextMode((int)extra);
            }
        }),
        AUTO_EJECT_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.toggleAutoEject();
            } else if (tile instanceof TileEntityLogisticalSorter) {
                TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)tile;
                sorter.toggleAutoEject();
            }
        }),
        AUTO_PULL_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.toggleAutoPull();
            }
        }),
        INVERSE_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.toggleInverse();
            } else if (tile instanceof TileEntityQIORedstoneAdapter) {
                TileEntityQIORedstoneAdapter adapter = (TileEntityQIORedstoneAdapter)tile;
                adapter.invertSignal();
            }
        }),
        INVERSE_REQUIRES_REPLACEMENT_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.toggleInverseRequiresReplacement();
            }
        }),
        RESET_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.reset();
            }
        }),
        SILK_TOUCH_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.toggleSilkTouch();
            }
        }),
        START_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.start();
            }
        }),
        STOP_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.stop();
            }
        }),
        SET_RADIUS((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.setRadiusFromPacket((int)extra);
            }
        }),
        SET_MIN_Y((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.setMinYFromPacket((int)extra);
            }
        }),
        SET_MAX_Y((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.setMaxYFromPacket((int)extra);
            }
        }),
        MOVE_FILTER_UP((tile, player, extra) -> {
            ITileFilterHolder filterHolder;
            FilterManager patt12964$temp;
            if (tile instanceof ITileFilterHolder && (patt12964$temp = (filterHolder = (ITileFilterHolder)((Object)tile)).getFilterManager()) instanceof SortableFilterManager) {
                SortableFilterManager manager = (SortableFilterManager)patt12964$temp;
                manager.moveUp((int)extra);
            }
        }),
        MOVE_FILTER_DOWN((tile, player, extra) -> {
            ITileFilterHolder filterHolder;
            FilterManager patt13229$temp;
            if (tile instanceof ITileFilterHolder && (patt13229$temp = (filterHolder = (ITileFilterHolder)((Object)tile)).getFilterManager()) instanceof SortableFilterManager) {
                SortableFilterManager manager = (SortableFilterManager)patt13229$temp;
                manager.moveDown((int)extra);
            }
        }),
        MOVE_FILTER_TO_TOP((tile, player, extra) -> {
            ITileFilterHolder filterHolder;
            FilterManager patt13498$temp;
            if (tile instanceof ITileFilterHolder && (patt13498$temp = (filterHolder = (ITileFilterHolder)((Object)tile)).getFilterManager()) instanceof SortableFilterManager) {
                SortableFilterManager manager = (SortableFilterManager)patt13498$temp;
                manager.moveToTop((int)extra);
            }
        }),
        MOVE_FILTER_TO_BOTTOM((tile, player, extra) -> {
            ITileFilterHolder filterHolder;
            FilterManager patt13771$temp;
            if (tile instanceof ITileFilterHolder && (patt13771$temp = (filterHolder = (ITileFilterHolder)((Object)tile)).getFilterManager()) instanceof SortableFilterManager) {
                SortableFilterManager manager = (SortableFilterManager)patt13771$temp;
                manager.moveToBottom((int)extra);
            }
        }),
        TOGGLE_FILTER_STATE((tile, player, extra) -> {
            if (tile instanceof ITileFilterHolder) {
                ITileFilterHolder filterHolder = (ITileFilterHolder)((Object)tile);
                filterHolder.getFilterManager().toggleState((int)extra);
            }
        }),
        REMOVE_UPGRADE((tile, player, extra) -> {
            if (tile.supportsUpgrades()) {
                tile.getComponent().removeUpgrade(Upgrade.byIndexStatic(extra), false);
            }
        }),
        REMOVE_ALL_UPGRADE((tile, player, extra) -> {
            if (tile.supportsUpgrades()) {
                tile.getComponent().removeUpgrade(Upgrade.byIndexStatic(extra), true);
            }
        }),
        NEXT_SECURITY_MODE((tile, player, extra) -> {
            if (tile.getLevel() != null) {
                SecurityUtils.get().incrementSecurityMode((Player)player, IBlockSecurityUtils.INSTANCE.securityCapability(tile.getLevel(), tile.getBlockPos(), (BlockEntity)tile));
            }
        }),
        PREVIOUS_SECURITY_MODE((tile, player, extra) -> {
            if (tile.getLevel() != null) {
                SecurityUtils.get().decrementSecurityMode((Player)player, IBlockSecurityUtils.INSTANCE.securityCapability(tile.getLevel(), tile.getBlockPos(), (BlockEntity)tile));
            }
        }),
        SECURITY_DESK_MODE((tile, player, extra) -> {
            if (tile instanceof TileEntitySecurityDesk) {
                TileEntitySecurityDesk desk = (TileEntitySecurityDesk)tile;
                desk.setSecurityDeskMode(SecurityMode.byIndexStatic(extra));
            }
        }),
        NEXT_MODE((tile, player, extra) -> {
            if (tile instanceof IHasMode) {
                IHasMode hasMode = (IHasMode)((Object)tile);
                hasMode.nextMode();
            }
        }),
        PREVIOUS_MODE((tile, player, extra) -> {
            if (tile instanceof IHasMode) {
                IHasMode hasMode = (IHasMode)((Object)tile);
                hasMode.previousMode();
            }
        }),
        NEXT_REDSTONE_CONTROL((tile, player, extra) -> tile.setControlType(tile.getControlType().getNext(tile::supportsMode))),
        PREVIOUS_REDSTONE_CONTROL((tile, player, extra) -> tile.setControlType(tile.getControlType().getPrevious(tile::supportsMode))),
        ENCODE_FORMULA((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                TileEntityFormulaicAssemblicator assemblicator = (TileEntityFormulaicAssemblicator)tile;
                assemblicator.encodeFormula();
            }
        }),
        STOCK_CONTROL_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                TileEntityFormulaicAssemblicator assemblicator = (TileEntityFormulaicAssemblicator)tile;
                assemblicator.toggleStockControl();
            }
        }),
        CRAFT_SINGLE((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                TileEntityFormulaicAssemblicator assemblicator = (TileEntityFormulaicAssemblicator)tile;
                assemblicator.craftSingle();
            }
        }),
        CRAFT_ALL((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                TileEntityFormulaicAssemblicator assemblicator = (TileEntityFormulaicAssemblicator)tile;
                assemblicator.craftAll();
            }
        }),
        EMPTY_GRID((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                TileEntityFormulaicAssemblicator assemblicator = (TileEntityFormulaicAssemblicator)tile;
                assemblicator.emptyGrid();
            }
        }),
        FILL_GRID((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                TileEntityFormulaicAssemblicator assemblicator = (TileEntityFormulaicAssemblicator)tile;
                assemblicator.fillGrid();
            }
        }),
        STRICT_INPUT((tile, player, extra) -> {
            if (tile instanceof ISideConfiguration) {
                TileComponentEjector ejector;
                ISideConfiguration sideConfiguration = (ISideConfiguration)((Object)tile);
                ejector.setStrictInput(!(ejector = sideConfiguration.getEjector()).hasStrictInput());
            }
        }),
        ROUND_ROBIN_BUTTON((tile, player, extra) -> {
            if (tile instanceof IAdvancedTransportEjector) {
                IAdvancedTransportEjector sorter = (IAdvancedTransportEjector)((Object)tile);
                sorter.toggleRoundRobin();
            }
        }),
        SINGLE_ITEM_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityLogisticalSorter) {
                TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)tile;
                sorter.toggleSingleItem();
            }
        }),
        CHANGE_COLOR((tile, player, extra) -> {
            if (tile instanceof TileEntityLogisticalSorter) {
                TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)tile;
                sorter.changeColor(TransporterUtils.readColor(extra));
            }
        }),
        OVERRIDE_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntitySecurityDesk) {
                TileEntitySecurityDesk desk = (TileEntitySecurityDesk)tile;
                desk.toggleOverride();
            }
        }),
        REMOVE_TRUSTED((tile, player, extra) -> {
            if (tile instanceof TileEntitySecurityDesk) {
                TileEntitySecurityDesk desk = (TileEntitySecurityDesk)tile;
                desk.removeTrusted((int)extra);
            }
        }),
        SET_TIME((tile, player, extra) -> {
            if (tile instanceof TileEntityLaserAmplifier) {
                TileEntityLaserAmplifier amplifier = (TileEntityLaserAmplifier)tile;
                amplifier.setDelay((int)extra);
            }
        }),
        TOGGLE_CHUNKLOAD((tile, player, extra) -> {
            if (tile instanceof TileEntityDimensionalStabilizer) {
                TileEntityDimensionalStabilizer stabilizer = (TileEntityDimensionalStabilizer)tile;
                stabilizer.toggleChunkLoadingAt(extra / 5, extra % 5);
            }
        }),
        ENABLE_RADIUS_CHUNKLOAD((tile, player, extra) -> {
            if (tile instanceof TileEntityDimensionalStabilizer) {
                TileEntityDimensionalStabilizer stabilizer = (TileEntityDimensionalStabilizer)tile;
                stabilizer.adjustChunkLoadingRadius((int)extra, true);
            }
        }),
        DISABLE_RADIUS_CHUNKLOAD((tile, player, extra) -> {
            if (tile instanceof TileEntityDimensionalStabilizer) {
                TileEntityDimensionalStabilizer stabilizer = (TileEntityDimensionalStabilizer)tile;
                stabilizer.adjustChunkLoadingRadius((int)extra, false);
            }
        });

        private final TriConsumer<TileEntityMekanism, Player, Integer> consumerForTile;

        private GuiInteraction(TriConsumer<TileEntityMekanism, Player, Integer> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, int extra) {
            this.consumerForTile.accept(tile, player, extra);
        }
    }

    public static enum GuiInteractionItem {
        DIGITAL_MINER_INVERSE_REPLACE_ITEM((tile, player, stack) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.setInverseReplaceTarget(stack.getItem());
            }
        }),
        QIO_REDSTONE_ADAPTER_STACK((tile, player, stack) -> {
            if (tile instanceof TileEntityQIORedstoneAdapter) {
                TileEntityQIORedstoneAdapter redstoneAdapter = (TileEntityQIORedstoneAdapter)tile;
                redstoneAdapter.handleStackChange((ItemStack)stack);
            }
        });

        private final TriConsumer<TileEntityMekanism, Player, ItemStack> consumerForTile;

        private GuiInteractionItem(TriConsumer<TileEntityMekanism, Player, ItemStack> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, ItemStack stack) {
            this.consumerForTile.accept(tile, player, stack);
        }
    }
}

