/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.api.functions.TriConsumer;
import mekanism.api.security.IItemSecurityUtils;
import mekanism.common.Mekanism;
import mekanism.common.lib.security.SecurityUtils;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.registries.MekanismAttachmentTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketItemGuiInteract(ItemGuiInteraction interaction, InteractionHand hand, int extra) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("item_gui_interact");

    public PacketItemGuiInteract(FriendlyByteBuf buffer) {
        this((ItemGuiInteraction)buffer.readEnum(ItemGuiInteraction.class), (InteractionHand)buffer.readEnum(InteractionHand.class), buffer.readVarInt());
    }

    public PacketItemGuiInteract(ItemGuiInteraction interaction, InteractionHand hand) {
        this(interaction, hand, 0);
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        ItemStack stack;
        Player player = context.player().orElse(null);
        if (player != null && !(stack = player.getItemInHand(this.hand)).isEmpty()) {
            this.interaction.consume(stack, player, this.extra);
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.interaction);
        buffer.writeEnum((Enum)this.hand);
        buffer.writeVarInt(this.extra);
    }

    public static enum ItemGuiInteraction {
        TARGET_DIRECTION_BUTTON((stack, player, extra) -> stack.setData(MekanismAttachmentTypes.INSERT_INTO_FREQUENCY, (Object)((Boolean)stack.getData(MekanismAttachmentTypes.INSERT_INTO_FREQUENCY) == false ? 1 : 0))),
        NEXT_SECURITY_MODE((stack, player, extra) -> SecurityUtils.get().incrementSecurityMode((Player)player, IItemSecurityUtils.INSTANCE.securityCapability((ItemStack)stack))),
        PREVIOUS_SECURITY_MODE((stack, player, extra) -> SecurityUtils.get().decrementSecurityMode((Player)player, IItemSecurityUtils.INSTANCE.securityCapability((ItemStack)stack)));

        private final TriConsumer<ItemStack, Player, Integer> consumerForTile;

        private ItemGuiInteraction(TriConsumer<ItemStack, Player, Integer> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(ItemStack stack, Player player, int extra) {
            this.consumerForTile.accept(stack, player, extra);
        }
    }
}

