/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketKey(int key, boolean add) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("key");

    public PacketKey(FriendlyByteBuf buffer) {
        this(buffer.readVarInt(), buffer.readBoolean());
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        UUID player = context.player().map(Entity::getUUID).orElse(null);
        if (player != null) {
            if (this.add) {
                Mekanism.keyMap.add(player, this.key);
            } else {
                Mekanism.keyMap.remove(player, this.key);
            }
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.key);
        buffer.writeBoolean(this.add);
    }
}

