/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.common.Mekanism;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketModeChange(EquipmentSlot slot, int shift, boolean displayChangeMessage) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("mode");

    public PacketModeChange(FriendlyByteBuf buffer) {
        this((EquipmentSlot)buffer.readEnum(EquipmentSlot.class), buffer.readVarInt(), buffer.readBoolean());
    }

    public PacketModeChange(EquipmentSlot slot, boolean holdingShift) {
        this(slot, holdingShift ? -1 : 1, true);
    }

    public PacketModeChange(EquipmentSlot slot, int shift) {
        this(slot, shift, false);
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        Item item;
        ItemStack stack;
        Player player = context.player().orElse(null);
        if (player != null && !(stack = player.getItemBySlot(this.slot)).isEmpty() && (item = stack.getItem()) instanceof IModeItem) {
            IModeItem modeItem = (IModeItem)item;
            IModeItem.DisplayChange displayChange = this.displayChangeMessage ? (this.slot == EquipmentSlot.MAINHAND ? IModeItem.DisplayChange.MAIN_HAND : IModeItem.DisplayChange.OTHER) : IModeItem.DisplayChange.NONE;
            modeItem.changeMode(player, stack, this.shift, displayChange);
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.slot);
        buffer.writeVarInt(this.shift);
        buffer.writeBoolean(this.displayChangeMessage);
    }
}

