/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.common.Mekanism;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketModeChangeCurios(String slotType, int slot, int shift, boolean displayChangeMessage) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("mode_curios");

    public PacketModeChangeCurios(FriendlyByteBuf buffer) {
        this(buffer.readUtf(), buffer.readVarInt(), buffer.readVarInt(), buffer.readBoolean());
    }

    public PacketModeChangeCurios(String slotType, int slot, boolean holdingShift) {
        this(slotType, slot, holdingShift ? -1 : 1, true);
    }

    public PacketModeChangeCurios(String slotType, int slot, int shift) {
        this(slotType, slot, shift, false);
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        Item item;
        ItemStack stack;
        Player player;
        if (Mekanism.hooks.CuriosLoaded && (player = (Player)context.player().orElse(null)) != null && !(stack = CuriosIntegration.getCurioStack((LivingEntity)player, this.slotType, this.slot)).isEmpty() && (item = stack.getItem()) instanceof IModeItem) {
            IModeItem modeItem = (IModeItem)item;
            modeItem.changeMode(player, stack, this.shift, this.displayChangeMessage ? IModeItem.DisplayChange.OTHER : IModeItem.DisplayChange.NONE);
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeUtf(this.slotType);
        buffer.writeVarInt(this.slot);
        buffer.writeVarInt(this.shift);
        buffer.writeBoolean(this.displayChangeMessage);
    }
}

