/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.ContainerProvider;
import mekanism.common.inventory.container.ModuleTweakerContainer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.registries.MekanismContainerTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public class PacketOpenGui
implements IMekanismPacket<PlayPayloadContext> {
    public static final ResourceLocation ID = Mekanism.rl("open_gui");
    private final GuiType type;

    public PacketOpenGui(FriendlyByteBuf buffer) {
        this((GuiType)buffer.readEnum(GuiType.class));
    }

    public PacketOpenGui(GuiType type) {
        this.type = type;
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        Player player = context.player().filter(this.type.shouldOpenForPlayer).orElse(null);
        if (player != null) {
            player.openMenu(this.type.containerSupplier.get());
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.type);
    }

    public static enum GuiType {
        MODULE_TWEAKER(() -> new ContainerProvider(MekanismLang.MODULE_TWEAKER, (id, inv, player) -> ((MenuType)MekanismContainerTypes.MODULE_TWEAKER.get()).create(id, inv)), ModuleTweakerContainer::hasTweakableItem);

        private final Supplier<MenuProvider> containerSupplier;
        private final Predicate<Player> shouldOpenForPlayer;

        private GuiType(Supplier<MenuProvider> containerSupplier) {
            this(containerSupplier, ConstantPredicates.alwaysTrue());
        }

        private GuiType(Supplier<MenuProvider> containerSupplier, Predicate<Player> shouldOpenForPlayer) {
            this.containerSupplier = containerSupplier;
            this.shouldOpenForPlayer = shouldOpenForPlayer;
        }
    }
}

