/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.event.MekanismTeleportEvent;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.item.ItemPortableTeleporter;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketPortableTeleporterTeleport(InteractionHand currentHand, Frequency.FrequencyIdentity identity) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("portable_teleport");

    public PacketPortableTeleporterTeleport(FriendlyByteBuf buffer) {
        this((InteractionHand)buffer.readEnum(InteractionHand.class), FrequencyType.TELEPORTER.getIdentitySerializer().read(buffer));
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        Optional<ServerPlayer> sender = PacketUtils.asServerPlayer((IPayloadContext)context);
        if (sender.isEmpty()) {
            return;
        }
        ServerPlayer player = sender.get();
        ItemStack stack = player.getItemInHand(this.currentHand);
        if (!stack.isEmpty() && stack.getItem() instanceof ItemPortableTeleporter) {
            MinecraftServer server;
            ServerLevel teleWorld;
            TileEntityTeleporter teleporter;
            TeleporterFrequency found = FrequencyType.TELEPORTER.getFrequency(this.identity, player.getUUID());
            if (found == null) {
                return;
            }
            GlobalPos coords = found.getClosestCoords(GlobalPos.of((ResourceKey)player.level().dimension(), (BlockPos)player.blockPosition()));
            if (coords != null && (teleporter = WorldUtils.getTileEntity(TileEntityTeleporter.class, (BlockGetter)(teleWorld = (server = player.level().getServer()) == null ? null : server.getLevel(coords.dimension())), coords.pos())) != null) {
                FloatingLong energyCost;
                Runnable energyExtraction = null;
                if (!player.isCreative()) {
                    energyCost = TileEntityTeleporter.calculateEnergyCost((Entity)player, (Level)teleWorld, coords);
                    IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                    if (energyContainer == null || energyContainer.extract(energyCost, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyCost)) {
                        return;
                    }
                    energyExtraction = () -> energyContainer.extract(energyCost, Action.EXECUTE, AutomationType.MANUAL);
                } else {
                    energyCost = FloatingLong.ZERO;
                }
                try {
                    teleporter.didTeleport.add(player.getUUID());
                    teleporter.teleDelay = 5;
                    BlockPos teleporterTargetPos = teleporter.getTeleporterTargetPos();
                    MekanismTeleportEvent.PortableTeleporter event = new MekanismTeleportEvent.PortableTeleporter((Player)player, teleporterTargetPos, (ResourceKey<Level>)coords.dimension(), stack, energyCost);
                    if (((MekanismTeleportEvent.PortableTeleporter)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
                        return;
                    }
                    if (energyExtraction != null) {
                        energyExtraction.run();
                    }
                    player.connection.aboveGroundTickCount = 0;
                    player.closeContainer();
                    PacketUtils.sendToAllTracking(new PacketPortalFX(player.blockPosition()), player.level(), coords.pos());
                    if (player.isPassenger()) {
                        player.stopRiding();
                    }
                    double oldX = player.getX();
                    double oldY = player.getY();
                    double oldZ = player.getZ();
                    Level oldWorld = player.level();
                    TileEntityTeleporter.teleportEntityTo((Entity)player, (Level)teleWorld, event, false);
                    TileEntityTeleporter.alignPlayer(player, event, teleporter);
                    if (player.level() != oldWorld || player.distanceToSqr(oldX, oldY, oldZ) >= 25.0) {
                        oldWorld.playSound(null, oldX, oldY, oldZ, SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                    teleporter.sendTeleportParticles();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.currentHand);
        FrequencyType.TELEPORTER.getIdentitySerializer().write(buffer, this.identity);
    }
}

