/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.List;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.INestedRadialMode;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.common.Mekanism;
import mekanism.common.lib.radial.IGenericRadialModeItem;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketRadialModeChange(EquipmentSlot slot, List<ResourceLocation> path, int networkRepresentation) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("radial_mode");

    public PacketRadialModeChange(FriendlyByteBuf buffer) {
        this((EquipmentSlot)buffer.readEnum(EquipmentSlot.class), buffer.readList(FriendlyByteBuf::readResourceLocation), buffer.readVarInt());
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        IGenericRadialModeItem radialModeItem;
        RadialData<?> radialData;
        Item item;
        ItemStack stack;
        Player player = context.player().orElse(null);
        if (player != null && !(stack = player.getItemBySlot(this.slot)).isEmpty() && (item = stack.getItem()) instanceof IGenericRadialModeItem && (radialData = (radialModeItem = (IGenericRadialModeItem)item).getRadialData(stack)) != null) {
            for (ResourceLocation path : this.path) {
                INestedRadialMode nestedData = radialData.fromIdentifier(path);
                if (nestedData == null || !nestedData.hasNestedData()) {
                    Mekanism.logger.warn("Could not find path ({}) in current radial data.", (Object)path);
                    return;
                }
                radialData = nestedData.nestedData();
            }
            this.setMode(player, stack, radialModeItem, radialData);
        }
    }

    private <MODE extends IRadialMode> void setMode(Player player, ItemStack stack, IGenericRadialModeItem item, RadialData<MODE> radialData) {
        MODE newMode = radialData.fromNetworkRepresentation(this.networkRepresentation);
        if (newMode != null) {
            item.setMode(stack, player, radialData, newMode);
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.slot);
        buffer.writeCollection(this.path, FriendlyByteBuf::writeResourceLocation);
        buffer.writeVarInt(this.networkRepresentation);
    }
}

