/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.api.MekanismAPI;
import mekanism.api.gear.ModuleData;
import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.TileEntityModificationStation;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketRemoveModule(BlockPos pos, ModuleData<?> moduleType, boolean removeAll) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("remove_module");

    public PacketRemoveModule(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), (ModuleData)buffer.readById(MekanismAPI.MODULE_REGISTRY), buffer.readBoolean());
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        TileEntityModificationStation tile;
        Player player = context.player().orElse(null);
        if (player != null && (tile = WorldUtils.getTileEntity(TileEntityModificationStation.class, (BlockGetter)player.level(), this.pos)) != null) {
            tile.removeModule(player, this.moduleType, this.removeAll);
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeId(MekanismAPI.MODULE_REGISTRY, this.moduleType);
        buffer.writeBoolean(this.removeAll);
    }
}

