/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.function.Predicate;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.IModule;
import mekanism.api.gear.ModuleData;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleColorData;
import mekanism.api.gear.config.ModuleConfigData;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.gear.config.ModuleIntegerData;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.common.Mekanism;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PacketUpdateModuleSettings
implements IMekanismPacket<PlayPayloadContext> {
    public static final ResourceLocation ID = Mekanism.rl("update_module");
    private final ModuleData<?> moduleType;
    private final int slotId;
    private final String data;
    private final ModuleDataType dataType;
    private final Object value;

    public static PacketUpdateModuleSettings create(int slotId, ModuleData<?> moduleType, ModuleConfigItem<?> configItem) {
        ModuleConfigData<?> configData = configItem.getData();
        if (configData instanceof ModuleEnumData) {
            ModuleEnumData enumData = (ModuleEnumData)configData;
            return new PacketUpdateModuleSettings(slotId, moduleType, configItem.getName(), ModuleDataType.ENUM, ((Enum)enumData.get()).ordinal());
        }
        for (ModuleDataType type : ModuleDataType.VALUES) {
            if (!type.typeMatches(configData)) continue;
            return new PacketUpdateModuleSettings(slotId, moduleType, configItem.getName(), type, configData.get());
        }
        throw new IllegalArgumentException("Unknown config data type for config with name: " + configItem.getName());
    }

    private PacketUpdateModuleSettings(int slotId, ModuleData<?> moduleType, String data, ModuleDataType dataType, Object value) {
        this.slotId = slotId;
        this.moduleType = moduleType;
        this.data = data;
        this.dataType = dataType;
        this.value = value;
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        Player player;
        if (!this.data.isBlank() && this.value != null && (player = (Player)context.player().orElse(null)) != null) {
            ItemStack stack = player.getInventory().getItem(this.slotId);
            IModule module = ModuleHelper.get().load(stack, (IModuleDataProvider)this.moduleType);
            if (module != null) {
                this.setValue((ModuleConfigItem)((Module)module).getConfigItem(this.data));
            }
        }
    }

    private <TYPE> void setValue(@Nullable ModuleConfigItem<TYPE> moduleConfigItem) {
        if (moduleConfigItem != null) {
            ModuleConfigData<TYPE> configData = moduleConfigItem.getData();
            if (configData instanceof ModuleEnumData && this.dataType == ModuleDataType.ENUM) {
                moduleConfigItem.set(MathUtils.getByIndexMod(((ModuleEnumData)configData).getEnums(), (int)((Integer)this.value)));
            } else if (this.dataType.typeMatches(configData)) {
                moduleConfigItem.set(this.value);
            }
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.dataType);
        buffer.writeVarInt(this.slotId);
        buffer.writeId(MekanismAPI.MODULE_REGISTRY, this.moduleType);
        buffer.writeUtf(this.data);
        this.dataType.writer.accept((Object)buffer, this.value);
    }

    public static PacketUpdateModuleSettings decode(FriendlyByteBuf buffer) {
        ModuleDataType dataType = (ModuleDataType)buffer.readEnum(ModuleDataType.class);
        return new PacketUpdateModuleSettings(buffer.readVarInt(), (ModuleData)buffer.readById(MekanismAPI.MODULE_REGISTRY), buffer.readUtf(), dataType, dataType.reader.apply((Object)buffer));
    }

    private static enum ModuleDataType {
        BOOLEAN(data -> data instanceof ModuleBooleanData, (FriendlyByteBuf.Writer<Object>)((FriendlyByteBuf.Writer)(buf, obj) -> buf.writeBoolean(((Boolean)obj).booleanValue())), (FriendlyByteBuf.Reader<Object>)((FriendlyByteBuf.Reader)FriendlyByteBuf::readBoolean)),
        COLOR(data -> data instanceof ModuleColorData, (FriendlyByteBuf.Writer<Object>)((FriendlyByteBuf.Writer)(buf, obj) -> buf.writeInt(((Integer)obj).intValue())), (FriendlyByteBuf.Reader<Object>)((FriendlyByteBuf.Reader)FriendlyByteBuf::readInt)),
        INTEGER(data -> data instanceof ModuleIntegerData, (FriendlyByteBuf.Writer<Object>)((FriendlyByteBuf.Writer)(buf, obj) -> buf.writeVarInt(((Integer)obj).intValue())), (FriendlyByteBuf.Reader<Object>)((FriendlyByteBuf.Reader)FriendlyByteBuf::readVarInt)),
        ENUM(data -> data instanceof ModuleEnumData, (FriendlyByteBuf.Writer<Object>)((FriendlyByteBuf.Writer)(buf, obj) -> buf.writeVarInt(((Integer)obj).intValue())), (FriendlyByteBuf.Reader<Object>)((FriendlyByteBuf.Reader)FriendlyByteBuf::readVarInt));

        private static final ModuleDataType[] VALUES;
        private final Predicate<ModuleConfigData<?>> configDataPredicate;
        private final FriendlyByteBuf.Writer<Object> writer;
        private final FriendlyByteBuf.Reader<Object> reader;

        private ModuleDataType(Predicate<ModuleConfigData<?>> configDataPredicate, FriendlyByteBuf.Writer<Object> writer, FriendlyByteBuf.Reader<Object> reader) {
            this.configDataPredicate = configDataPredicate;
            this.writer = writer;
            this.reader = reader;
        }

        public boolean typeMatches(ModuleConfigData<?> data) {
            return this.configDataPredicate.test(data);
        }

        static {
            VALUES = ModuleDataType.values();
        }
    }
}

