/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.common.Mekanism;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PacketWindowSelect(@Nullable SelectedWindowData selectedWindow) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("window_select");

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        AbstractContainerMenu abstractContainerMenu;
        Player player = context.player().orElse(null);
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof MekanismContainer) {
            MekanismContainer container = (MekanismContainer)abstractContainerMenu;
            container.setSelectedWindow(player.getUUID(), this.selectedWindow);
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        if (this.selectedWindow == null) {
            buffer.writeByte(-1);
        } else {
            buffer.writeByte(this.selectedWindow.extraData);
            buffer.writeEnum((Enum)this.selectedWindow.type);
        }
    }

    public static PacketWindowSelect decode(FriendlyByteBuf buffer) {
        byte extraData = buffer.readByte();
        if (extraData == -1) {
            return new PacketWindowSelect(null);
        }
        SelectedWindowData.WindowType windowType = (SelectedWindowData.WindowType)buffer.readEnum(SelectedWindowData.WindowType.class);
        return new PacketWindowSelect(windowType == SelectedWindowData.WindowType.UNSPECIFIED ? SelectedWindowData.UNSPECIFIED : new SelectedWindowData(windowType, extraData));
    }
}

