/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.button;

import java.util.function.Function;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.registries.MekanismContainerTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PacketEntityButtonPress(ClickedEntityButton buttonClicked, int entityID) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("entity_button");

    public PacketEntityButtonPress(FriendlyByteBuf buffer) {
        this((ClickedEntityButton)buffer.readEnum(ClickedEntityButton.class), buffer.readVarInt());
    }

    public PacketEntityButtonPress(ClickedEntityButton buttonClicked, Entity entity) {
        this(buttonClicked, entity.getId());
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        Entity entity;
        Player player = context.player().orElse(null);
        if (player != null && (entity = player.level().getEntity(this.entityID)) != null) {
            player.openMenu(this.buttonClicked.getProvider(entity), buf -> buf.writeVarInt(this.entityID));
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.buttonClicked);
        buffer.writeVarInt(this.entityID);
    }

    public static enum ClickedEntityButton {
        ROBIT_CRAFTING(entity -> MekanismContainerTypes.CRAFTING_ROBIT.getProvider(MekanismLang.ROBIT_CRAFTING, entity)),
        ROBIT_INVENTORY(entity -> MekanismContainerTypes.INVENTORY_ROBIT.getProvider(MekanismLang.ROBIT_INVENTORY, entity)),
        ROBIT_MAIN(entity -> MekanismContainerTypes.MAIN_ROBIT.getProvider(MekanismLang.ROBIT, entity)),
        ROBIT_REPAIR(entity -> MekanismContainerTypes.REPAIR_ROBIT.getProvider(MekanismLang.ROBIT_REPAIR, entity)),
        ROBIT_SMELTING(entity -> MekanismContainerTypes.SMELTING_ROBIT.getProvider(MekanismLang.ROBIT_SMELTING, entity));

        private final Function<Entity, @Nullable MenuProvider> providerFromEntity;

        private ClickedEntityButton(Function<Entity, MenuProvider> providerFromEntity) {
            this.providerFromEntity = providerFromEntity;
        }

        @Nullable
        public MenuProvider getProvider(Entity entity) {
            return this.providerFromEntity.apply(entity);
        }
    }
}

