/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.button;

import java.util.function.BiFunction;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.item.interfaces.IGuiItem;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.registries.MekanismContainerTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PacketItemButtonPress(ClickedItemButton buttonClicked, InteractionHand hand) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("item_button");

    public PacketItemButtonPress(FriendlyByteBuf buffer) {
        this((ClickedItemButton)buffer.readEnum(ClickedItemButton.class), (InteractionHand)buffer.readEnum(InteractionHand.class));
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        ItemStack stack;
        Player player = context.player().orElse(null);
        if (player != null && (stack = player.getItemInHand(this.hand)).getItem() instanceof IGuiItem) {
            player.openMenu(this.buttonClicked.getProvider(stack, this.hand), buf -> {
                buf.writeEnum((Enum)this.hand);
                buf.writeItem(stack);
            });
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.buttonClicked);
        buffer.writeEnum((Enum)this.hand);
    }

    public static enum ClickedItemButton {
        BACK_BUTTON((stack, hand) -> {
            Item patt2050$temp = stack.getItem();
            if (patt2050$temp instanceof IGuiItem) {
                IGuiItem guiItem = (IGuiItem)patt2050$temp;
                return guiItem.getContainerType().getProvider(stack.getHoverName(), (InteractionHand)hand, (ItemStack)stack);
            }
            return null;
        }),
        QIO_FREQUENCY_SELECT((stack, hand) -> MekanismContainerTypes.QIO_FREQUENCY_SELECT_ITEM.getProvider((ILangEntry)MekanismLang.QIO_FREQUENCY_SELECT, (InteractionHand)hand, (ItemStack)stack));

        private final BiFunction<ItemStack, InteractionHand, @Nullable MenuProvider> providerFromItem;

        private ClickedItemButton(BiFunction<ItemStack, InteractionHand, MenuProvider> providerFromItem) {
            this.providerFromItem = providerFromItem;
        }

        @Nullable
        public MenuProvider getProvider(ItemStack stack, InteractionHand hand) {
            return this.providerFromItem.apply(stack, hand);
        }
    }
}

