/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.configuration_update;

import mekanism.api.RelativeSide;
import mekanism.common.Mekanism;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PacketBatchConfiguration(BlockPos pos, @Nullable TransmissionType transmission, DataType targetType) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("batch_configuration");

    public PacketBatchConfiguration(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), (TransmissionType)buffer.readNullable(buf -> (TransmissionType)buf.readEnum(TransmissionType.class)), (DataType)buffer.readEnum(DataType.class));
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        TileComponentConfig configComponent = PacketUtils.config((IPayloadContext)context, this.pos);
        if (configComponent != null) {
            if (this.transmission == null) {
                for (TransmissionType type : configComponent.getTransmissions()) {
                    this.updateAllSides(configComponent, type, configComponent.getConfig(type));
                }
                return;
            }
            ConfigInfo info = configComponent.getConfig(this.transmission);
            if (info != null) {
                this.updateAllSides(configComponent, this.transmission, info);
            }
        }
    }

    private void updateAllSides(TileComponentConfig configComponent, TransmissionType transmission, @Nullable ConfigInfo info) {
        if (info != null && info.supports(this.targetType)) {
            for (RelativeSide side : EnumUtils.SIDES) {
                if (!info.isSideEnabled(side) || info.getDataType(side) == this.targetType) continue;
                info.setDataType(this.targetType, side);
                configComponent.sideChanged(transmission, side);
            }
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeNullable((Object)this.transmission, FriendlyByteBuf::writeEnum);
        buffer.writeEnum((Enum)this.targetType);
    }
}

