/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.configuration_update;

import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.MekClickType;
import mekanism.common.network.PacketUtils;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.util.TransporterUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketEjectColor(BlockPos pos, MekClickType clickType) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("eject_color");

    public PacketEjectColor(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), (MekClickType)buffer.readEnum(MekClickType.class));
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        TileComponentEjector ejector = PacketUtils.ejector((IPayloadContext)context, this.pos);
        if (ejector != null) {
            ejector.setOutputColor(switch (this.clickType) {
                default -> throw new IncompatibleClassChangeError();
                case MekClickType.LEFT -> TransporterUtils.increment(ejector.getOutputColor());
                case MekClickType.RIGHT -> TransporterUtils.decrement(ejector.getOutputColor());
                case MekClickType.SHIFT_LEFT -> null;
            });
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeEnum((Enum)this.clickType);
    }
}

