/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.configuration_update;

import mekanism.common.Mekanism;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketEjectConfiguration(BlockPos pos, TransmissionType transmission) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("eject_configuration");

    public PacketEjectConfiguration(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), (TransmissionType)buffer.readEnum(TransmissionType.class));
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        ConfigInfo info;
        TileComponentConfig configComponent = PacketUtils.config((IPayloadContext)context, this.pos);
        if (configComponent != null && (info = configComponent.getConfig(this.transmission)) != null) {
            info.setEjecting(!info.isEjecting());
            configComponent.tile.markForSave();
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeEnum((Enum)this.transmission);
    }
}

