/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.configuration_update;

import mekanism.api.RelativeSide;
import mekanism.common.Mekanism;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.MekClickType;
import mekanism.common.network.PacketUtils;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketSideData(BlockPos pos, MekClickType clickType, RelativeSide inputSide, TransmissionType transmission) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("side_data");

    public PacketSideData(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), (MekClickType)buffer.readEnum(MekClickType.class), (RelativeSide)buffer.readEnum(RelativeSide.class), (TransmissionType)buffer.readEnum(TransmissionType.class));
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        ConfigInfo info;
        TileComponentConfig configComponent = PacketUtils.config((IPayloadContext)context, this.pos);
        if (configComponent != null && (info = configComponent.getConfig(this.transmission)) != null) {
            boolean changed;
            DataType type = info.getDataType(this.inputSide);
            boolean bl = changed = type != (switch (this.clickType) {
                default -> throw new IncompatibleClassChangeError();
                case MekClickType.LEFT -> info.incrementDataType(this.inputSide);
                case MekClickType.RIGHT -> info.decrementDataType(this.inputSide);
                case MekClickType.SHIFT_LEFT -> {
                    if (type != DataType.NONE) {
                        info.setDataType(DataType.NONE, this.inputSide);
                    }
                    yield DataType.NONE;
                }
            });
            if (changed) {
                configComponent.sideChanged(this.transmission, this.inputSide);
            }
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeEnum((Enum)this.clickType);
        buffer.writeEnum((Enum)this.inputSide);
        buffer.writeEnum((Enum)this.transmission);
    }
}

