/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.filter;

import mekanism.common.Mekanism;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.content.filter.IFilter;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PacketEditFilter<FILTER extends IFilter<FILTER>>(BlockPos pos, FILTER filter, @Nullable FILTER edited) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("edit_filter");
    private static final PacketEditFilter<?> ERROR = new PacketEditFilter<Object>(BlockPos.ZERO, null, null);

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        FilterManager<?> filterManager;
        if (this.filter != null && (filterManager = PacketUtils.filterManager((IPayloadContext)context, this.pos)) != null) {
            filterManager.tryEditFilter(this.filter, this.edited);
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        this.filter.write(buffer);
        buffer.writeNullable(this.edited, (buf, editedFilter) -> editedFilter.write((FriendlyByteBuf)buf));
    }

    public static <FILTER extends IFilter<FILTER>> PacketEditFilter<?> decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        IFilter<?> filter = BaseFilter.readFromPacket(buffer);
        IFilter edited = (IFilter)buffer.readNullable(BaseFilter::readFromPacket);
        if (edited != null && edited.getFilterType() != filter.getFilterType()) {
            return ERROR;
        }
        return new PacketEditFilter<IFilter>(pos, filter, edited);
    }
}

