/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.filter;

import mekanism.common.Mekanism;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.content.filter.IFilter;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketNewFilter(BlockPos pos, IFilter<?> filter) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("new_filter");

    public PacketNewFilter(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), BaseFilter.readFromPacket(buffer));
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        FilterManager<?> filterManager = PacketUtils.filterManager((IPayloadContext)context, this.pos);
        if (filterManager != null) {
            filterManager.tryAddFilter(this.filter, true);
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        this.filter.write(buffer);
    }
}

