/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.frequency;

import mekanism.api.security.IItemSecurityUtils;
import mekanism.common.Mekanism;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.network.to_server.frequency.PacketSetFrequency;
import mekanism.common.registries.MekanismAttachmentTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public class PacketSetItemFrequency<FREQ extends Frequency>
extends PacketSetFrequency<FREQ> {
    public static final ResourceLocation ID = Mekanism.rl("set_item_frequency");
    private final InteractionHand currentHand;

    public PacketSetItemFrequency(FriendlyByteBuf buf) {
        super(buf);
        this.currentHand = (InteractionHand)buf.readEnum(InteractionHand.class);
    }

    public PacketSetItemFrequency(boolean set, FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, InteractionHand currentHand) {
        super(set, type, data);
        this.currentHand = currentHand;
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        ItemStack stack;
        Player player = context.player().orElse(null);
        if (player != null && (stack = player.getItemInHand(this.currentHand)).getItem() instanceof IFrequencyItem && IItemSecurityUtils.INSTANCE.canAccess(player, stack)) {
            FrequencyAware frequencyAware = (FrequencyAware)stack.getData(MekanismAttachmentTypes.FREQUENCY_AWARE);
            if (this.set) {
                frequencyAware.setFrequency(this.data, player.getUUID());
            } else {
                frequencyAware.removeFrequency(this.data, player.getUUID());
            }
        }
    }

    @Override
    public void write(@NotNull FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeEnum((Enum)this.currentHand);
    }
}

