/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.frequency;

import mekanism.api.security.IBlockSecurityUtils;
import mekanism.common.Mekanism;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyHandler;
import mekanism.common.network.to_server.frequency.PacketSetFrequency;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public class PacketSetTileFrequency<FREQ extends Frequency>
extends PacketSetFrequency<FREQ> {
    public static final ResourceLocation ID = Mekanism.rl("set_tile_frequency");
    private final BlockPos pos;

    public PacketSetTileFrequency(FriendlyByteBuf buf) {
        super(buf);
        this.pos = buf.readBlockPos();
    }

    public PacketSetTileFrequency(boolean set, FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, BlockPos pos) {
        super(set, type, data);
        this.pos = pos;
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        BlockEntity tile;
        Player player = context.player().orElse(null);
        if (player != null && (tile = WorldUtils.getTileEntity((BlockGetter)player.level(), this.pos)) instanceof IFrequencyHandler) {
            IFrequencyHandler frequencyHandler = (IFrequencyHandler)tile;
            if (IBlockSecurityUtils.INSTANCE.canAccess(player, player.level(), this.pos, tile)) {
                if (this.set) {
                    frequencyHandler.setFrequency(this.type, this.data, player.getUUID());
                } else {
                    frequencyHandler.removeFrequency(this.type, this.data, player.getUUID());
                }
            }
        }
    }

    @Override
    public void write(@NotNull FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeBlockPos(this.pos);
    }
}

